/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse;

public class ListModelVersionsPublisher
implements SdkPublisher<ListModelVersionsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListModelVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelVersionsPublisher(LookoutEquipmentAsyncClient client, ListModelVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelVersionsPublisher(LookoutEquipmentAsyncClient client, ListModelVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListModelVersionsResponseFetcher
    implements AsyncPageFetcher<ListModelVersionsResponse> {
        private ListModelVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelVersionsResponse> nextPage(ListModelVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelVersionsPublisher.this.client.listModelVersions(ListModelVersionsPublisher.this.firstRequest);
            }
            return ListModelVersionsPublisher.this.client.listModelVersions((ListModelVersionsRequest)((Object)ListModelVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

