/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsAsyncClient;
import software.amazon.awssdk.services.lookoutmetrics.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse;

public class GetFeedbackPublisher
implements SdkPublisher<GetFeedbackResponse> {
    private final LookoutMetricsAsyncClient client;
    private final GetFeedbackRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFeedbackPublisher(LookoutMetricsAsyncClient client, GetFeedbackRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFeedbackPublisher(LookoutMetricsAsyncClient client, GetFeedbackRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFeedbackResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFeedbackResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetFeedbackResponseFetcher
    implements AsyncPageFetcher<GetFeedbackResponse> {
        private GetFeedbackResponseFetcher() {
        }

        public boolean hasNextPage(GetFeedbackResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFeedbackResponse> nextPage(GetFeedbackResponse previousPage) {
            if (previousPage == null) {
                return GetFeedbackPublisher.this.client.getFeedback(GetFeedbackPublisher.this.firstRequest);
            }
            return GetFeedbackPublisher.this.client.getFeedback((GetFeedbackRequest)((Object)GetFeedbackPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

