/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionClient;
import software.amazon.awssdk.services.lookoutvision.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata;

public class ListModelPackagingJobsIterable
implements SdkIterable<ListModelPackagingJobsResponse> {
    private final LookoutVisionClient client;
    private final ListModelPackagingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelPackagingJobsIterable(LookoutVisionClient client, ListModelPackagingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelPackagingJobsResponseFetcher();
    }

    public Iterator<ListModelPackagingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelPackagingJobMetadata> modelPackagingJobs() {
        Function<ListModelPackagingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelPackagingJobs() != null) {
                return response.modelPackagingJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelPackagingJobsResponseFetcher
    implements SyncPageFetcher<ListModelPackagingJobsResponse> {
        private ListModelPackagingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelPackagingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelPackagingJobsResponse nextPage(ListModelPackagingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelPackagingJobsIterable.this.client.listModelPackagingJobs(ListModelPackagingJobsIterable.this.firstRequest);
            }
            return ListModelPackagingJobsIterable.this.client.listModelPackagingJobs((ListModelPackagingJobsRequest)((Object)ListModelPackagingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

