/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie.MacieAsyncClient;
import software.amazon.awssdk.services.macie.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse;

public class ListS3ResourcesPublisher
implements SdkPublisher<ListS3ResourcesResponse> {
    private final MacieAsyncClient client;
    private final ListS3ResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListS3ResourcesPublisher(MacieAsyncClient client, ListS3ResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListS3ResourcesPublisher(MacieAsyncClient client, ListS3ResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListS3ResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListS3ResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListS3ResourcesResponseFetcher
    implements AsyncPageFetcher<ListS3ResourcesResponse> {
        private ListS3ResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListS3ResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListS3ResourcesResponse> nextPage(ListS3ResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListS3ResourcesPublisher.this.client.listS3Resources(ListS3ResourcesPublisher.this.firstRequest);
            }
            return ListS3ResourcesPublisher.this.client.listS3Resources((ListS3ResourcesRequest)((Object)ListS3ResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

