/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryClient;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryServiceClientConfiguration;
import software.amazon.awssdk.services.managedblockchainquery.internal.ManagedBlockchainQueryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.managedblockchainquery.model.AccessDeniedException;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.InternalServerException;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryException;
import software.amazon.awssdk.services.managedblockchainquery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.managedblockchainquery.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.managedblockchainquery.model.ThrottlingException;
import software.amazon.awssdk.services.managedblockchainquery.model.ValidationException;
import software.amazon.awssdk.services.managedblockchainquery.transform.BatchGetTokenBalanceRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.GetAssetContractRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.GetTokenBalanceRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.GetTransactionRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.ListAssetContractsRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.ListTokenBalancesRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.ListTransactionEventsRequestMarshaller;
import software.amazon.awssdk.services.managedblockchainquery.transform.ListTransactionsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultManagedBlockchainQueryClient
implements ManagedBlockchainQueryClient {
    private static final Logger log = Logger.loggerFor(DefaultManagedBlockchainQueryClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ManagedBlockchainQueryServiceClientConfiguration serviceClientConfiguration;

    protected DefaultManagedBlockchainQueryClient(ManagedBlockchainQueryServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetTokenBalanceResponse batchGetTokenBalance(BatchGetTokenBalanceRequest batchGetTokenBalanceRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetTokenBalanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetTokenBalanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, batchGetTokenBalanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetTokenBalance");
            BatchGetTokenBalanceResponse batchGetTokenBalanceResponse = (BatchGetTokenBalanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetTokenBalance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetTokenBalanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetTokenBalanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetTokenBalanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$batchGetTokenBalance$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssetContractResponse getAssetContract(GetAssetContractRequest getAssetContractRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssetContractResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssetContractRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, getAssetContractRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssetContract");
            GetAssetContractResponse getAssetContractResponse = (GetAssetContractResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssetContract").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAssetContractRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssetContractRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssetContractResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$getAssetContract$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTokenBalanceResponse getTokenBalance(GetTokenBalanceRequest getTokenBalanceRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTokenBalanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTokenBalanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, getTokenBalanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTokenBalance");
            GetTokenBalanceResponse getTokenBalanceResponse = (GetTokenBalanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTokenBalance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTokenBalanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTokenBalanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTokenBalanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$getTokenBalance$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTransactionResponse getTransaction(GetTransactionRequest getTransactionRequest) throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, getTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTransaction");
            GetTransactionResponse getTransactionResponse = (GetTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$getTransaction$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssetContractsResponse listAssetContracts(ListAssetContractsRequest listAssetContractsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssetContractsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssetContractsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, listAssetContractsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssetContracts");
            ListAssetContractsResponse listAssetContractsResponse = (ListAssetContractsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssetContracts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssetContractsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssetContractsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssetContractsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$listAssetContracts$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTokenBalancesResponse listTokenBalances(ListTokenBalancesRequest listTokenBalancesRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTokenBalancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTokenBalancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, listTokenBalancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTokenBalances");
            ListTokenBalancesResponse listTokenBalancesResponse = (ListTokenBalancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTokenBalances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTokenBalancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTokenBalancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTokenBalancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$listTokenBalances$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTransactionEventsResponse listTransactionEvents(ListTransactionEventsRequest listTransactionEventsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTransactionEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTransactionEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, listTransactionEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTransactionEvents");
            ListTransactionEventsResponse listTransactionEventsResponse = (ListTransactionEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTransactionEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTransactionEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTransactionEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTransactionEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$listTransactionEvents$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTransactionsResponse listTransactions(ListTransactionsRequest listTransactionsRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ManagedBlockchainQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTransactionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTransactionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultManagedBlockchainQueryClient.resolveMetricPublishers(clientConfiguration, listTransactionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ManagedBlockchain Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTransactions");
            ListTransactionsResponse listTransactionsResponse = (ListTransactionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTransactions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTransactionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTransactionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTransactionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultManagedBlockchainQueryClient.lambda$listTransactions$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "managedblockchain-query";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        ManagedBlockchainQueryServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = ManagedBlockchainQueryServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ManagedBlockchainQueryException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final ManagedBlockchainQueryServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$listTransactions$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTransactionEvents$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTokenBalances$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssetContracts$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTransaction$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTokenBalance$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssetContract$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetTokenBalance$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

