/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryTransactionEventType {
    ERC20_TRANSFER("ERC20_TRANSFER"),
    ERC20_MINT("ERC20_MINT"),
    ERC20_BURN("ERC20_BURN"),
    ERC20_DEPOSIT("ERC20_DEPOSIT"),
    ERC20_WITHDRAWAL("ERC20_WITHDRAWAL"),
    ERC721_TRANSFER("ERC721_TRANSFER"),
    ERC1155_TRANSFER("ERC1155_TRANSFER"),
    BITCOIN_VIN("BITCOIN_VIN"),
    BITCOIN_VOUT("BITCOIN_VOUT"),
    INTERNAL_ETH_TRANSFER("INTERNAL_ETH_TRANSFER"),
    ETH_TRANSFER("ETH_TRANSFER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryTransactionEventType> VALUE_MAP;
    private final String value;

    private QueryTransactionEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryTransactionEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryTransactionEventType> knownValues() {
        EnumSet<QueryTransactionEventType> knownValues = EnumSet.allOf(QueryTransactionEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryTransactionEventType.class, QueryTransactionEventType::toString);
    }
}

