/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum M2tsCcDescriptor {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, M2tsCcDescriptor> VALUE_MAP;
    private final String value;

    private M2tsCcDescriptor(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static M2tsCcDescriptor fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<M2tsCcDescriptor> knownValues() {
        EnumSet<M2tsCcDescriptor> knownValues = EnumSet.allOf(M2tsCcDescriptor.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(M2tsCcDescriptor.class, M2tsCcDescriptor::toString);
    }
}

