/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MaintenanceDay;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceCreateSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceCreateSettings> {
    private static final SdkField<String> MAINTENANCE_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceDay").getter(MaintenanceCreateSettings.getter(MaintenanceCreateSettings::maintenanceDayAsString)).setter(MaintenanceCreateSettings.setter(Builder::maintenanceDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDay").build()}).build();
    private static final SdkField<String> MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceStartTime").getter(MaintenanceCreateSettings.getter(MaintenanceCreateSettings::maintenanceStartTime)).setter(MaintenanceCreateSettings.setter(Builder::maintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_DAY_FIELD, MAINTENANCE_START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String maintenanceDay;
    private final String maintenanceStartTime;

    private MaintenanceCreateSettings(BuilderImpl builder) {
        this.maintenanceDay = builder.maintenanceDay;
        this.maintenanceStartTime = builder.maintenanceStartTime;
    }

    public final MaintenanceDay maintenanceDay() {
        return MaintenanceDay.fromValue(this.maintenanceDay);
    }

    public final String maintenanceDayAsString() {
        return this.maintenanceDay;
    }

    public final String maintenanceStartTime() {
        return this.maintenanceStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceCreateSettings)) {
            return false;
        }
        MaintenanceCreateSettings other = (MaintenanceCreateSettings)obj;
        return Objects.equals(this.maintenanceDayAsString(), other.maintenanceDayAsString()) && Objects.equals(this.maintenanceStartTime(), other.maintenanceStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceCreateSettings").add("MaintenanceDay", (Object)this.maintenanceDayAsString()).add("MaintenanceStartTime", (Object)this.maintenanceStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceDay": {
                return Optional.ofNullable(clazz.cast(this.maintenanceDayAsString()));
            }
            case "MaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceCreateSettings, T> g) {
        return obj -> g.apply((MaintenanceCreateSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maintenanceDay;
        private String maintenanceStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceCreateSettings model) {
            this.maintenanceDay(model.maintenanceDay);
            this.maintenanceStartTime(model.maintenanceStartTime);
        }

        public final String getMaintenanceDay() {
            return this.maintenanceDay;
        }

        public final void setMaintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
        }

        @Override
        public final Builder maintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
            return this;
        }

        @Override
        public final Builder maintenanceDay(MaintenanceDay maintenanceDay) {
            this.maintenanceDay(maintenanceDay == null ? null : maintenanceDay.toString());
            return this;
        }

        public final String getMaintenanceStartTime() {
            return this.maintenanceStartTime;
        }

        public final void setMaintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
        }

        @Override
        public final Builder maintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            return this;
        }

        public MaintenanceCreateSettings build() {
            return new MaintenanceCreateSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceCreateSettings> {
        public Builder maintenanceDay(String var1);

        public Builder maintenanceDay(MaintenanceDay var1);

        public Builder maintenanceStartTime(String var1);
    }
}

