/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CmafEncryptionMethod {
    SAMPLE_AES("SAMPLE_AES"),
    AES_CTR("AES_CTR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafEncryptionMethod> VALUE_MAP;
    private final String value;

    private CmafEncryptionMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CmafEncryptionMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CmafEncryptionMethod> knownValues() {
        EnumSet<CmafEncryptionMethod> knownValues = EnumSet.allOf(CmafEncryptionMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CmafEncryptionMethod.class, CmafEncryptionMethod::toString);
    }
}

