/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResource;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse;

public class ListDiscoveredResourcesIterable
implements SdkIterable<ListDiscoveredResourcesResponse> {
    private final MigrationHubClient client;
    private final ListDiscoveredResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDiscoveredResourcesIterable(MigrationHubClient client, ListDiscoveredResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDiscoveredResourcesResponseFetcher();
    }

    public Iterator<ListDiscoveredResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DiscoveredResource> discoveredResourceList() {
        Function<ListDiscoveredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.discoveredResourceList() != null) {
                return response.discoveredResourceList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDiscoveredResourcesResponseFetcher
    implements SyncPageFetcher<ListDiscoveredResourcesResponse> {
        private ListDiscoveredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDiscoveredResourcesResponse nextPage(ListDiscoveredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveredResourcesIterable.this.client.listDiscoveredResources(ListDiscoveredResourcesIterable.this.firstRequest);
            }
            return ListDiscoveredResourcesIterable.this.client.listDiscoveredResources((ListDiscoveredResourcesRequest)((Object)ListDiscoveredResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

