/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceCodeAnalyzerName {
    CSHARP_ANALYZER("CSHARP_ANALYZER"),
    JAVA_ANALYZER("JAVA_ANALYZER"),
    BYTECODE_ANALYZER("BYTECODE_ANALYZER"),
    PORTING_ASSISTANT("PORTING_ASSISTANT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceCodeAnalyzerName> VALUE_MAP;
    private final String value;

    private SourceCodeAnalyzerName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceCodeAnalyzerName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceCodeAnalyzerName> knownValues() {
        EnumSet<SourceCodeAnalyzerName> knownValues = EnumSet.allOf(SourceCodeAnalyzerName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceCodeAnalyzerName.class, SourceCodeAnalyzerName::toString);
    }
}

