/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse;

public class ListAnalyzableServersIterable
implements SdkIterable<ListAnalyzableServersResponse> {
    private final MigrationHubStrategyClient client;
    private final ListAnalyzableServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnalyzableServersIterable(MigrationHubStrategyClient client, ListAnalyzableServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnalyzableServersResponseFetcher();
    }

    public Iterator<ListAnalyzableServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalyzableServerSummary> analyzableServers() {
        Function<ListAnalyzableServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.analyzableServers() != null) {
                return response.analyzableServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnalyzableServersResponseFetcher
    implements SyncPageFetcher<ListAnalyzableServersResponse> {
        private ListAnalyzableServersResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalyzableServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnalyzableServersResponse nextPage(ListAnalyzableServersResponse previousPage) {
            if (previousPage == null) {
                return ListAnalyzableServersIterable.this.client.listAnalyzableServers(ListAnalyzableServersIterable.this.firstRequest);
            }
            return ListAnalyzableServersIterable.this.client.listAnalyzableServers((ListAnalyzableServersRequest)((Object)ListAnalyzableServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

