/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyAsyncClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.ImportFileTaskInformation;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse;

public class ListImportFileTaskPublisher
implements SdkPublisher<ListImportFileTaskResponse> {
    private final MigrationHubStrategyAsyncClient client;
    private final ListImportFileTaskRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportFileTaskPublisher(MigrationHubStrategyAsyncClient client, ListImportFileTaskRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportFileTaskPublisher(MigrationHubStrategyAsyncClient client, ListImportFileTaskRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportFileTaskResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportFileTaskResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportFileTaskInformation> taskInfos() {
        Function<ListImportFileTaskResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskInfos() != null) {
                return response.taskInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImportFileTaskResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImportFileTaskResponseFetcher
    implements AsyncPageFetcher<ListImportFileTaskResponse> {
        private ListImportFileTaskResponseFetcher() {
        }

        public boolean hasNextPage(ListImportFileTaskResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportFileTaskResponse> nextPage(ListImportFileTaskResponse previousPage) {
            if (previousPage == null) {
                return ListImportFileTaskPublisher.this.client.listImportFileTask(ListImportFileTaskPublisher.this.firstRequest);
            }
            return ListImportFileTaskPublisher.this.client.listImportFileTask((ListImportFileTaskRequest)((Object)ListImportFileTaskPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

