/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.StreamingSessionBackup;
import software.amazon.awssdk.services.nimble.model.StreamingSessionBackupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamingSessionBackupsResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListStreamingSessionBackupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStreamingSessionBackupsResponse.getter(ListStreamingSessionBackupsResponse::nextToken)).setter(ListStreamingSessionBackupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StreamingSessionBackup>> STREAMING_SESSION_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamingSessionBackups").getter(ListStreamingSessionBackupsResponse.getter(ListStreamingSessionBackupsResponse::streamingSessionBackups)).setter(ListStreamingSessionBackupsResponse.setter(Builder::streamingSessionBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingSessionBackups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingSessionBackup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STREAMING_SESSION_BACKUPS_FIELD));
    private final String nextToken;
    private final List<StreamingSessionBackup> streamingSessionBackups;

    private ListStreamingSessionBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamingSessionBackups = builder.streamingSessionBackups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStreamingSessionBackups() {
        return this.streamingSessionBackups != null && !(this.streamingSessionBackups instanceof SdkAutoConstructList);
    }

    public final List<StreamingSessionBackup> streamingSessionBackups() {
        return this.streamingSessionBackups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamingSessionBackups() ? this.streamingSessionBackups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingSessionBackupsResponse)) {
            return false;
        }
        ListStreamingSessionBackupsResponse other = (ListStreamingSessionBackupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStreamingSessionBackups() == other.hasStreamingSessionBackups() && Objects.equals(this.streamingSessionBackups(), other.streamingSessionBackups());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamingSessionBackupsResponse").add("NextToken", (Object)this.nextToken()).add("StreamingSessionBackups", this.hasStreamingSessionBackups() ? this.streamingSessionBackups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "streamingSessionBackups": {
                return Optional.ofNullable(clazz.cast(this.streamingSessionBackups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingSessionBackupsResponse, T> g) {
        return obj -> g.apply((ListStreamingSessionBackupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StreamingSessionBackup> streamingSessionBackups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingSessionBackupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.streamingSessionBackups(model.streamingSessionBackups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamingSessionBackup.Builder> getStreamingSessionBackups() {
            List<StreamingSessionBackup.Builder> result = StreamingSessionBackupListCopier.copyToBuilder(this.streamingSessionBackups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingSessionBackups(Collection<StreamingSessionBackup.BuilderImpl> streamingSessionBackups) {
            this.streamingSessionBackups = StreamingSessionBackupListCopier.copyFromBuilder(streamingSessionBackups);
        }

        @Override
        public final Builder streamingSessionBackups(Collection<StreamingSessionBackup> streamingSessionBackups) {
            this.streamingSessionBackups = StreamingSessionBackupListCopier.copy(streamingSessionBackups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingSessionBackups(StreamingSessionBackup ... streamingSessionBackups) {
            this.streamingSessionBackups(Arrays.asList(streamingSessionBackups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingSessionBackups(Consumer<StreamingSessionBackup.Builder> ... streamingSessionBackups) {
            this.streamingSessionBackups(Stream.of(streamingSessionBackups).map(c -> (StreamingSessionBackup)((StreamingSessionBackup.Builder)StreamingSessionBackup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamingSessionBackupsResponse build() {
            return new ListStreamingSessionBackupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamingSessionBackupsResponse> {
        public Builder nextToken(String var1);

        public Builder streamingSessionBackups(Collection<StreamingSessionBackup> var1);

        public Builder streamingSessionBackups(StreamingSessionBackup ... var1);

        public Builder streamingSessionBackups(Consumer<StreamingSessionBackup.Builder> ... var1);
    }
}

