/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StudioComponentType {
    ACTIVE_DIRECTORY("ACTIVE_DIRECTORY"),
    SHARED_FILE_SYSTEM("SHARED_FILE_SYSTEM"),
    COMPUTE_FARM("COMPUTE_FARM"),
    LICENSE_SERVICE("LICENSE_SERVICE"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StudioComponentType> VALUE_MAP;
    private final String value;

    private StudioComponentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StudioComponentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StudioComponentType> knownValues() {
        EnumSet<StudioComponentType> knownValues = EnumSet.allOf(StudioComponentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StudioComponentType.class, StudioComponentType::toString);
    }
}

