/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.internal.UserAgentUtils;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse;
import software.amazon.awssdk.services.nimble.model.StreamingImage;

public class ListStreamingImagesPublisher
implements SdkPublisher<ListStreamingImagesResponse> {
    private final NimbleAsyncClient client;
    private final ListStreamingImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamingImagesPublisher(NimbleAsyncClient client, ListStreamingImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamingImagesPublisher(NimbleAsyncClient client, ListStreamingImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamingImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamingImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamingImage> streamingImages() {
        Function<ListStreamingImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingImages() != null) {
                return response.streamingImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamingImagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamingImagesResponseFetcher
    implements AsyncPageFetcher<ListStreamingImagesResponse> {
        private ListStreamingImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamingImagesResponse> nextPage(ListStreamingImagesResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingImagesPublisher.this.client.listStreamingImages(ListStreamingImagesPublisher.this.firstRequest);
            }
            return ListStreamingImagesPublisher.this.client.listStreamingImages((ListStreamingImagesRequest)((Object)ListStreamingImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

