/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.endpoints.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.SignerLoader;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.awscore.util.SignerOverrideUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.omics.endpoints.OmicsEndpointParams;
import software.amazon.awssdk.services.omics.endpoints.OmicsEndpointProvider;
import software.amazon.awssdk.services.omics.endpoints.internal.AuthSchemeUtils;
import software.amazon.awssdk.services.omics.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class OmicsResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        OmicsEndpointProvider provider = (OmicsEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint endpoint = provider.resolveEndpoint(OmicsResolveEndpointInterceptor.ruleParams(result, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = OmicsResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            if (endpointAuthSchemes != null) {
                EndpointAuthScheme chosenAuthScheme = AuthSchemeUtils.chooseAuthScheme(endpointAuthSchemes);
                Supplier<Signer> signerProvider = this.signerProvider(chosenAuthScheme);
                result = SignerOverrideUtils.overrideSignerIfNotOverridden((SdkRequest)result, (ExecutionAttributes)executionAttributes, signerProvider);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static OmicsEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        OmicsEndpointParams.Builder builder = OmicsEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        OmicsResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        OmicsResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(OmicsEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(OmicsEndpointParams.Builder params, String operationName) {
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        Iterator<EndpointAuthScheme> iterator = endpointAuthSchemes.iterator();
        if (iterator.hasNext()) {
            EndpointAuthScheme endpointAuthScheme = iterator.next();
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4aAuthScheme.signingRegionSet() != null) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "AbortMultipartReadSetUpload": {
                return Optional.of("control-storage-");
            }
            case "AcceptShare": {
                return Optional.of("analytics-");
            }
            case "BatchDeleteReadSet": {
                return Optional.of("control-storage-");
            }
            case "CancelAnnotationImportJob": {
                return Optional.of("analytics-");
            }
            case "CancelRun": {
                return Optional.of("workflows-");
            }
            case "CancelVariantImportJob": {
                return Optional.of("analytics-");
            }
            case "CompleteMultipartReadSetUpload": {
                return Optional.of("storage-");
            }
            case "CreateAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "CreateAnnotationStoreVersion": {
                return Optional.of("analytics-");
            }
            case "CreateMultipartReadSetUpload": {
                return Optional.of("control-storage-");
            }
            case "CreateReferenceStore": {
                return Optional.of("control-storage-");
            }
            case "CreateRunGroup": {
                return Optional.of("workflows-");
            }
            case "CreateSequenceStore": {
                return Optional.of("control-storage-");
            }
            case "CreateShare": {
                return Optional.of("analytics-");
            }
            case "CreateVariantStore": {
                return Optional.of("analytics-");
            }
            case "CreateWorkflow": {
                return Optional.of("workflows-");
            }
            case "DeleteAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "DeleteAnnotationStoreVersions": {
                return Optional.of("analytics-");
            }
            case "DeleteReference": {
                return Optional.of("control-storage-");
            }
            case "DeleteReferenceStore": {
                return Optional.of("control-storage-");
            }
            case "DeleteRun": {
                return Optional.of("workflows-");
            }
            case "DeleteRunGroup": {
                return Optional.of("workflows-");
            }
            case "DeleteSequenceStore": {
                return Optional.of("control-storage-");
            }
            case "DeleteShare": {
                return Optional.of("analytics-");
            }
            case "DeleteVariantStore": {
                return Optional.of("analytics-");
            }
            case "DeleteWorkflow": {
                return Optional.of("workflows-");
            }
            case "GetAnnotationImportJob": {
                return Optional.of("analytics-");
            }
            case "GetAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "GetAnnotationStoreVersion": {
                return Optional.of("analytics-");
            }
            case "GetReadSet": {
                return Optional.of("storage-");
            }
            case "GetReadSetActivationJob": {
                return Optional.of("control-storage-");
            }
            case "GetReadSetExportJob": {
                return Optional.of("control-storage-");
            }
            case "GetReadSetImportJob": {
                return Optional.of("control-storage-");
            }
            case "GetReadSetMetadata": {
                return Optional.of("control-storage-");
            }
            case "GetReference": {
                return Optional.of("storage-");
            }
            case "GetReferenceImportJob": {
                return Optional.of("control-storage-");
            }
            case "GetReferenceMetadata": {
                return Optional.of("control-storage-");
            }
            case "GetReferenceStore": {
                return Optional.of("control-storage-");
            }
            case "GetRun": {
                return Optional.of("workflows-");
            }
            case "GetRunGroup": {
                return Optional.of("workflows-");
            }
            case "GetRunTask": {
                return Optional.of("workflows-");
            }
            case "GetSequenceStore": {
                return Optional.of("control-storage-");
            }
            case "GetShare": {
                return Optional.of("analytics-");
            }
            case "GetVariantImportJob": {
                return Optional.of("analytics-");
            }
            case "GetVariantStore": {
                return Optional.of("analytics-");
            }
            case "GetWorkflow": {
                return Optional.of("workflows-");
            }
            case "ListAnnotationImportJobs": {
                return Optional.of("analytics-");
            }
            case "ListAnnotationStoreVersions": {
                return Optional.of("analytics-");
            }
            case "ListAnnotationStores": {
                return Optional.of("analytics-");
            }
            case "ListMultipartReadSetUploads": {
                return Optional.of("control-storage-");
            }
            case "ListReadSetActivationJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReadSetExportJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReadSetImportJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReadSetUploadParts": {
                return Optional.of("control-storage-");
            }
            case "ListReadSets": {
                return Optional.of("control-storage-");
            }
            case "ListReferenceImportJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReferenceStores": {
                return Optional.of("control-storage-");
            }
            case "ListReferences": {
                return Optional.of("control-storage-");
            }
            case "ListRunGroups": {
                return Optional.of("workflows-");
            }
            case "ListRunTasks": {
                return Optional.of("workflows-");
            }
            case "ListRuns": {
                return Optional.of("workflows-");
            }
            case "ListSequenceStores": {
                return Optional.of("control-storage-");
            }
            case "ListShares": {
                return Optional.of("analytics-");
            }
            case "ListTagsForResource": {
                return Optional.of("tags-");
            }
            case "ListVariantImportJobs": {
                return Optional.of("analytics-");
            }
            case "ListVariantStores": {
                return Optional.of("analytics-");
            }
            case "ListWorkflows": {
                return Optional.of("workflows-");
            }
            case "StartAnnotationImportJob": {
                return Optional.of("analytics-");
            }
            case "StartReadSetActivationJob": {
                return Optional.of("control-storage-");
            }
            case "StartReadSetExportJob": {
                return Optional.of("control-storage-");
            }
            case "StartReadSetImportJob": {
                return Optional.of("control-storage-");
            }
            case "StartReferenceImportJob": {
                return Optional.of("control-storage-");
            }
            case "StartRun": {
                return Optional.of("workflows-");
            }
            case "StartVariantImportJob": {
                return Optional.of("analytics-");
            }
            case "TagResource": {
                return Optional.of("tags-");
            }
            case "UntagResource": {
                return Optional.of("tags-");
            }
            case "UpdateAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "UpdateAnnotationStoreVersion": {
                return Optional.of("analytics-");
            }
            case "UpdateRunGroup": {
                return Optional.of("workflows-");
            }
            case "UpdateVariantStore": {
                return Optional.of("analytics-");
            }
            case "UpdateWorkflow": {
                return Optional.of("workflows-");
            }
            case "UploadReadSetPart": {
                return Optional.of("storage-");
            }
        }
        return Optional.empty();
    }

    private Supplier<Signer> signerProvider(EndpointAuthScheme authScheme) {
        switch (authScheme.name()) {
            case "sigv4": {
                return Aws4Signer::create;
            }
            case "sigv4a": {
                return SignerLoader::getSigV4aSigner;
            }
        }
        throw SdkClientException.create((String)("Don't know how to create signer for auth scheme: " + authScheme.name()));
    }
}

