/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.SseConfig;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVariantStoreRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateVariantStoreRequest> {
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(CreateVariantStoreRequest.getter(CreateVariantStoreRequest::reference)).setter(CreateVariantStoreRequest.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateVariantStoreRequest.getter(CreateVariantStoreRequest::name)).setter(CreateVariantStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateVariantStoreRequest.getter(CreateVariantStoreRequest::description)).setter(CreateVariantStoreRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateVariantStoreRequest.getter(CreateVariantStoreRequest::tags)).setter(CreateVariantStoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sseConfig").getter(CreateVariantStoreRequest.getter(CreateVariantStoreRequest::sseConfig)).setter(CreateVariantStoreRequest.setter(Builder::sseConfig)).constructor(SseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SSE_CONFIG_FIELD));
    private final ReferenceItem reference;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final SseConfig sseConfig;

    private CreateVariantStoreRequest(BuilderImpl builder) {
        super(builder);
        this.reference = builder.reference;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.sseConfig = builder.sseConfig;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final SseConfig sseConfig() {
        return this.sseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVariantStoreRequest)) {
            return false;
        }
        CreateVariantStoreRequest other = (CreateVariantStoreRequest)((Object)obj);
        return Objects.equals(this.reference(), other.reference()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sseConfig(), other.sseConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVariantStoreRequest").add("Reference", (Object)this.reference()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("SseConfig", (Object)this.sseConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "sseConfig": {
                return Optional.ofNullable(clazz.cast(this.sseConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVariantStoreRequest, T> g) {
        return obj -> g.apply((CreateVariantStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private ReferenceItem reference;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private SseConfig sseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVariantStoreRequest model) {
            super(model);
            this.reference(model.reference);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.sseConfig(model.sseConfig);
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return this.sseConfig != null ? this.sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVariantStoreRequest build() {
            return new CreateVariantStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVariantStoreRequest> {
        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder sseConfig(SseConfig var1);

        default public Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return this.sseConfig((SseConfig)((SseConfig.Builder)SseConfig.builder().applyMutation(sseConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

