/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse;

public class ListAnnotationStoreVersionsPublisher
implements SdkPublisher<ListAnnotationStoreVersionsResponse> {
    private final OmicsAsyncClient client;
    private final ListAnnotationStoreVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnnotationStoreVersionsPublisher(OmicsAsyncClient client, ListAnnotationStoreVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnnotationStoreVersionsPublisher(OmicsAsyncClient client, ListAnnotationStoreVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnnotationStoreVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnnotationStoreVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnnotationStoreVersionItem> annotationStoreVersions() {
        Function<ListAnnotationStoreVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.annotationStoreVersions() != null) {
                return response.annotationStoreVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnnotationStoreVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnnotationStoreVersionsResponseFetcher
    implements AsyncPageFetcher<ListAnnotationStoreVersionsResponse> {
        private ListAnnotationStoreVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnnotationStoreVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnnotationStoreVersionsResponse> nextPage(ListAnnotationStoreVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAnnotationStoreVersionsPublisher.this.client.listAnnotationStoreVersions(ListAnnotationStoreVersionsPublisher.this.firstRequest);
            }
            return ListAnnotationStoreVersionsPublisher.this.client.listAnnotationStoreVersions((ListAnnotationStoreVersionsRequest)((Object)ListAnnotationStoreVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

