/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ReferenceStoreDetail;

public class ListReferenceStoresPublisher
implements SdkPublisher<ListReferenceStoresResponse> {
    private final OmicsAsyncClient client;
    private final ListReferenceStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReferenceStoresPublisher(OmicsAsyncClient client, ListReferenceStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReferenceStoresPublisher(OmicsAsyncClient client, ListReferenceStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReferenceStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReferenceStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReferenceStoreDetail> referenceStores() {
        Function<ListReferenceStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.referenceStores() != null) {
                return response.referenceStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReferenceStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReferenceStoresResponseFetcher
    implements AsyncPageFetcher<ListReferenceStoresResponse> {
        private ListReferenceStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListReferenceStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReferenceStoresResponse> nextPage(ListReferenceStoresResponse previousPage) {
            if (previousPage == null) {
                return ListReferenceStoresPublisher.this.client.listReferenceStores(ListReferenceStoresPublisher.this.firstRequest);
            }
            return ListReferenceStoresPublisher.this.client.listReferenceStores((ListReferenceStoresRequest)((Object)ListReferenceStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

