/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingThresholds
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingThresholds> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(AutoScalingThresholds.getter(AutoScalingThresholds::instanceCount)).setter(AutoScalingThresholds.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Integer> THRESHOLDS_WAIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThresholdsWaitTime").getter(AutoScalingThresholds.getter(AutoScalingThresholds::thresholdsWaitTime)).setter(AutoScalingThresholds.setter(Builder::thresholdsWaitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdsWaitTime").build()}).build();
    private static final SdkField<Integer> IGNORE_METRICS_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IgnoreMetricsTime").getter(AutoScalingThresholds.getter(AutoScalingThresholds::ignoreMetricsTime)).setter(AutoScalingThresholds.setter(Builder::ignoreMetricsTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreMetricsTime").build()}).build();
    private static final SdkField<Double> CPU_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CpuThreshold").getter(AutoScalingThresholds.getter(AutoScalingThresholds::cpuThreshold)).setter(AutoScalingThresholds.setter(Builder::cpuThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuThreshold").build()}).build();
    private static final SdkField<Double> MEMORY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MemoryThreshold").getter(AutoScalingThresholds.getter(AutoScalingThresholds::memoryThreshold)).setter(AutoScalingThresholds.setter(Builder::memoryThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryThreshold").build()}).build();
    private static final SdkField<Double> LOAD_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LoadThreshold").getter(AutoScalingThresholds.getter(AutoScalingThresholds::loadThreshold)).setter(AutoScalingThresholds.setter(Builder::loadThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadThreshold").build()}).build();
    private static final SdkField<List<String>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(AutoScalingThresholds.getter(AutoScalingThresholds::alarms)).setter(AutoScalingThresholds.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, THRESHOLDS_WAIT_TIME_FIELD, IGNORE_METRICS_TIME_FIELD, CPU_THRESHOLD_FIELD, MEMORY_THRESHOLD_FIELD, LOAD_THRESHOLD_FIELD, ALARMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final Integer thresholdsWaitTime;
    private final Integer ignoreMetricsTime;
    private final Double cpuThreshold;
    private final Double memoryThreshold;
    private final Double loadThreshold;
    private final List<String> alarms;

    private AutoScalingThresholds(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.thresholdsWaitTime = builder.thresholdsWaitTime;
        this.ignoreMetricsTime = builder.ignoreMetricsTime;
        this.cpuThreshold = builder.cpuThreshold;
        this.memoryThreshold = builder.memoryThreshold;
        this.loadThreshold = builder.loadThreshold;
        this.alarms = builder.alarms;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Integer thresholdsWaitTime() {
        return this.thresholdsWaitTime;
    }

    public final Integer ignoreMetricsTime() {
        return this.ignoreMetricsTime;
    }

    public final Double cpuThreshold() {
        return this.cpuThreshold;
    }

    public final Double memoryThreshold() {
        return this.memoryThreshold;
    }

    public final Double loadThreshold() {
        return this.loadThreshold;
    }

    public final boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public final List<String> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdsWaitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreMetricsTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarms() ? this.alarms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingThresholds)) {
            return false;
        }
        AutoScalingThresholds other = (AutoScalingThresholds)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.thresholdsWaitTime(), other.thresholdsWaitTime()) && Objects.equals(this.ignoreMetricsTime(), other.ignoreMetricsTime()) && Objects.equals(this.cpuThreshold(), other.cpuThreshold()) && Objects.equals(this.memoryThreshold(), other.memoryThreshold()) && Objects.equals(this.loadThreshold(), other.loadThreshold()) && this.hasAlarms() == other.hasAlarms() && Objects.equals(this.alarms(), other.alarms());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingThresholds").add("InstanceCount", (Object)this.instanceCount()).add("ThresholdsWaitTime", (Object)this.thresholdsWaitTime()).add("IgnoreMetricsTime", (Object)this.ignoreMetricsTime()).add("CpuThreshold", (Object)this.cpuThreshold()).add("MemoryThreshold", (Object)this.memoryThreshold()).add("LoadThreshold", (Object)this.loadThreshold()).add("Alarms", this.hasAlarms() ? this.alarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "ThresholdsWaitTime": {
                return Optional.ofNullable(clazz.cast(this.thresholdsWaitTime()));
            }
            case "IgnoreMetricsTime": {
                return Optional.ofNullable(clazz.cast(this.ignoreMetricsTime()));
            }
            case "CpuThreshold": {
                return Optional.ofNullable(clazz.cast(this.cpuThreshold()));
            }
            case "MemoryThreshold": {
                return Optional.ofNullable(clazz.cast(this.memoryThreshold()));
            }
            case "LoadThreshold": {
                return Optional.ofNullable(clazz.cast(this.loadThreshold()));
            }
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingThresholds, T> g) {
        return obj -> g.apply((AutoScalingThresholds)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private Integer thresholdsWaitTime;
        private Integer ignoreMetricsTime;
        private Double cpuThreshold;
        private Double memoryThreshold;
        private Double loadThreshold;
        private List<String> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingThresholds model) {
            this.instanceCount(model.instanceCount);
            this.thresholdsWaitTime(model.thresholdsWaitTime);
            this.ignoreMetricsTime(model.ignoreMetricsTime);
            this.cpuThreshold(model.cpuThreshold);
            this.memoryThreshold(model.memoryThreshold);
            this.loadThreshold(model.loadThreshold);
            this.alarms(model.alarms);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getThresholdsWaitTime() {
            return this.thresholdsWaitTime;
        }

        public final void setThresholdsWaitTime(Integer thresholdsWaitTime) {
            this.thresholdsWaitTime = thresholdsWaitTime;
        }

        @Override
        public final Builder thresholdsWaitTime(Integer thresholdsWaitTime) {
            this.thresholdsWaitTime = thresholdsWaitTime;
            return this;
        }

        public final Integer getIgnoreMetricsTime() {
            return this.ignoreMetricsTime;
        }

        public final void setIgnoreMetricsTime(Integer ignoreMetricsTime) {
            this.ignoreMetricsTime = ignoreMetricsTime;
        }

        @Override
        public final Builder ignoreMetricsTime(Integer ignoreMetricsTime) {
            this.ignoreMetricsTime = ignoreMetricsTime;
            return this;
        }

        public final Double getCpuThreshold() {
            return this.cpuThreshold;
        }

        public final void setCpuThreshold(Double cpuThreshold) {
            this.cpuThreshold = cpuThreshold;
        }

        @Override
        public final Builder cpuThreshold(Double cpuThreshold) {
            this.cpuThreshold = cpuThreshold;
            return this;
        }

        public final Double getMemoryThreshold() {
            return this.memoryThreshold;
        }

        public final void setMemoryThreshold(Double memoryThreshold) {
            this.memoryThreshold = memoryThreshold;
        }

        @Override
        public final Builder memoryThreshold(Double memoryThreshold) {
            this.memoryThreshold = memoryThreshold;
            return this;
        }

        public final Double getLoadThreshold() {
            return this.loadThreshold;
        }

        public final void setLoadThreshold(Double loadThreshold) {
            this.loadThreshold = loadThreshold;
        }

        @Override
        public final Builder loadThreshold(Double loadThreshold) {
            this.loadThreshold = loadThreshold;
            return this;
        }

        public final Collection<String> getAlarms() {
            if (this.alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarms;
        }

        public final void setAlarms(Collection<String> alarms) {
            this.alarms = StringsCopier.copy(alarms);
        }

        @Override
        public final Builder alarms(Collection<String> alarms) {
            this.alarms = StringsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(String ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public AutoScalingThresholds build() {
            return new AutoScalingThresholds(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingThresholds> {
        public Builder instanceCount(Integer var1);

        public Builder thresholdsWaitTime(Integer var1);

        public Builder ignoreMetricsTime(Integer var1);

        public Builder cpuThreshold(Double var1);

        public Builder memoryThreshold(Double var1);

        public Builder loadThreshold(Double var1);

        public Builder alarms(Collection<String> var1);

        public Builder alarms(String ... var1);
    }
}

