/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.organizations.DefaultOrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.DefaultOrganizationsBaseClientBuilder;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClientBuilder;
import software.amazon.awssdk.services.organizations.OrganizationsServiceClientConfiguration;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointProvider;

@SdkInternalApi
final class DefaultOrganizationsAsyncClientBuilder
extends DefaultOrganizationsBaseClientBuilder<OrganizationsAsyncClientBuilder, OrganizationsAsyncClient>
implements OrganizationsAsyncClientBuilder {
    DefaultOrganizationsAsyncClientBuilder() {
    }

    @Override
    public DefaultOrganizationsAsyncClientBuilder endpointProvider(OrganizationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OrganizationsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOrganizationsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        OrganizationsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOrganizationsAsyncClient client = new DefaultOrganizationsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OrganizationsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OrganizationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

