/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.DelegatedService;
import software.amazon.awssdk.services.organizations.model.DelegatedServicesCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDelegatedServicesForAccountResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListDelegatedServicesForAccountResponse> {
    private static final SdkField<List<DelegatedService>> DELEGATED_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DelegatedServices").getter(ListDelegatedServicesForAccountResponse.getter(ListDelegatedServicesForAccountResponse::delegatedServices)).setter(ListDelegatedServicesForAccountResponse.setter(Builder::delegatedServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegatedServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DelegatedService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDelegatedServicesForAccountResponse.getter(ListDelegatedServicesForAccountResponse::nextToken)).setter(ListDelegatedServicesForAccountResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATED_SERVICES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DelegatedService> delegatedServices;
    private final String nextToken;

    private ListDelegatedServicesForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.delegatedServices = builder.delegatedServices;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDelegatedServices() {
        return this.delegatedServices != null && !(this.delegatedServices instanceof SdkAutoConstructList);
    }

    public final List<DelegatedService> delegatedServices() {
        return this.delegatedServices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegatedServices() ? this.delegatedServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDelegatedServicesForAccountResponse)) {
            return false;
        }
        ListDelegatedServicesForAccountResponse other = (ListDelegatedServicesForAccountResponse)((Object)obj);
        return this.hasDelegatedServices() == other.hasDelegatedServices() && Objects.equals(this.delegatedServices(), other.delegatedServices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDelegatedServicesForAccountResponse").add("DelegatedServices", this.hasDelegatedServices() ? this.delegatedServices() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegatedServices": {
                return Optional.ofNullable(clazz.cast(this.delegatedServices()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDelegatedServicesForAccountResponse, T> g) {
        return obj -> g.apply((ListDelegatedServicesForAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<DelegatedService> delegatedServices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDelegatedServicesForAccountResponse model) {
            super(model);
            this.delegatedServices(model.delegatedServices);
            this.nextToken(model.nextToken);
        }

        public final List<DelegatedService.Builder> getDelegatedServices() {
            List<DelegatedService.Builder> result = DelegatedServicesCopier.copyToBuilder(this.delegatedServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegatedServices(Collection<DelegatedService.BuilderImpl> delegatedServices) {
            this.delegatedServices = DelegatedServicesCopier.copyFromBuilder(delegatedServices);
        }

        @Override
        public final Builder delegatedServices(Collection<DelegatedService> delegatedServices) {
            this.delegatedServices = DelegatedServicesCopier.copy(delegatedServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedServices(DelegatedService ... delegatedServices) {
            this.delegatedServices(Arrays.asList(delegatedServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedServices(Consumer<DelegatedService.Builder> ... delegatedServices) {
            this.delegatedServices(Stream.of(delegatedServices).map(c -> (DelegatedService)((DelegatedService.Builder)DelegatedService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDelegatedServicesForAccountResponse build() {
            return new ListDelegatedServicesForAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDelegatedServicesForAccountResponse> {
        public Builder delegatedServices(Collection<DelegatedService> var1);

        public Builder delegatedServices(DelegatedService ... var1);

        public Builder delegatedServices(Consumer<DelegatedService.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

