/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.NtpServerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NtpPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NtpPayload> {
    private static final SdkField<List<String>> NTP_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NtpServers").getter(NtpPayload.getter(NtpPayload::ntpServers)).setter(NtpPayload.setter(Builder::ntpServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NtpServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NTP_SERVERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> ntpServers;

    private NtpPayload(BuilderImpl builder) {
        this.ntpServers = builder.ntpServers;
    }

    public final boolean hasNtpServers() {
        return this.ntpServers != null && !(this.ntpServers instanceof SdkAutoConstructList);
    }

    public final List<String> ntpServers() {
        return this.ntpServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNtpServers() ? this.ntpServers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NtpPayload)) {
            return false;
        }
        NtpPayload other = (NtpPayload)obj;
        return this.hasNtpServers() == other.hasNtpServers() && Objects.equals(this.ntpServers(), other.ntpServers());
    }

    public final String toString() {
        return ToString.builder((String)"NtpPayload").add("NtpServers", this.hasNtpServers() ? this.ntpServers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NtpServers": {
                return Optional.ofNullable(clazz.cast(this.ntpServers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NtpPayload, T> g) {
        return obj -> g.apply((NtpPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ntpServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NtpPayload model) {
            this.ntpServers(model.ntpServers);
        }

        public final Collection<String> getNtpServers() {
            if (this.ntpServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ntpServers;
        }

        public final void setNtpServers(Collection<String> ntpServers) {
            this.ntpServers = NtpServerListCopier.copy(ntpServers);
        }

        @Override
        public final Builder ntpServers(Collection<String> ntpServers) {
            this.ntpServers = NtpServerListCopier.copy(ntpServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ntpServers(String ... ntpServers) {
            this.ntpServers(Arrays.asList(ntpServers));
            return this;
        }

        public NtpPayload build() {
            return new NtpPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NtpPayload> {
        public Builder ntpServers(Collection<String> var1);

        public Builder ntpServers(String ... var1);
    }
}

