/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdClient;
import software.amazon.awssdk.services.pcaconnectorad.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ServicePrincipalNameSummary;

public class ListServicePrincipalNamesIterable
implements SdkIterable<ListServicePrincipalNamesResponse> {
    private final PcaConnectorAdClient client;
    private final ListServicePrincipalNamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicePrincipalNamesIterable(PcaConnectorAdClient client, ListServicePrincipalNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServicePrincipalNamesResponseFetcher();
    }

    public Iterator<ListServicePrincipalNamesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServicePrincipalNameSummary> servicePrincipalNames() {
        Function<ListServicePrincipalNamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.servicePrincipalNames() != null) {
                return response.servicePrincipalNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServicePrincipalNamesResponseFetcher
    implements SyncPageFetcher<ListServicePrincipalNamesResponse> {
        private ListServicePrincipalNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicePrincipalNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicePrincipalNamesResponse nextPage(ListServicePrincipalNamesResponse previousPage) {
            if (previousPage == null) {
                return ListServicePrincipalNamesIterable.this.client.listServicePrincipalNames(ListServicePrincipalNamesIterable.this.firstRequest);
            }
            return ListServicePrincipalNamesIterable.this.client.listServicePrincipalNames((ListServicePrincipalNamesRequest)((Object)ListServicePrincipalNamesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

