/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobStatus {
    CREATED("CREATED"),
    PREPARING_FOR_INITIALIZATION("PREPARING_FOR_INITIALIZATION"),
    INITIALIZING("INITIALIZING"),
    PROCESSING("PROCESSING"),
    PENDING_JOB("PENDING_JOB"),
    COMPLETING("COMPLETING"),
    COMPLETED("COMPLETED"),
    FAILING("FAILING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobStatus> VALUE_MAP;
    private final String value;

    private JobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobStatus> knownValues() {
        EnumSet<JobStatus> knownValues = EnumSet.allOf(JobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobStatus.class, JobStatus::toString);
    }
}

