/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfManagedKafkaAccessConfigurationCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfManagedKafkaAccessConfigurationCredentials> {
    private static final SdkField<String> BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BasicAuth").getter(SelfManagedKafkaAccessConfigurationCredentials.getter(SelfManagedKafkaAccessConfigurationCredentials::basicAuth)).setter(SelfManagedKafkaAccessConfigurationCredentials.setter(Builder::basicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuth").build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_TLS_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCertificateTlsAuth").getter(SelfManagedKafkaAccessConfigurationCredentials.getter(SelfManagedKafkaAccessConfigurationCredentials::clientCertificateTlsAuth)).setter(SelfManagedKafkaAccessConfigurationCredentials.setter(Builder::clientCertificateTlsAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateTlsAuth").build()}).build();
    private static final SdkField<String> SASL_SCRAM256_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SaslScram256Auth").getter(SelfManagedKafkaAccessConfigurationCredentials.getter(SelfManagedKafkaAccessConfigurationCredentials::saslScram256Auth)).setter(SelfManagedKafkaAccessConfigurationCredentials.setter(Builder::saslScram256Auth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslScram256Auth").build()}).build();
    private static final SdkField<String> SASL_SCRAM512_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SaslScram512Auth").getter(SelfManagedKafkaAccessConfigurationCredentials.getter(SelfManagedKafkaAccessConfigurationCredentials::saslScram512Auth)).setter(SelfManagedKafkaAccessConfigurationCredentials.setter(Builder::saslScram512Auth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslScram512Auth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_FIELD, CLIENT_CERTIFICATE_TLS_AUTH_FIELD, SASL_SCRAM256_AUTH_FIELD, SASL_SCRAM512_AUTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String basicAuth;
    private final String clientCertificateTlsAuth;
    private final String saslScram256Auth;
    private final String saslScram512Auth;
    private final Type type;

    private SelfManagedKafkaAccessConfigurationCredentials(BuilderImpl builder) {
        this.basicAuth = builder.basicAuth;
        this.clientCertificateTlsAuth = builder.clientCertificateTlsAuth;
        this.saslScram256Auth = builder.saslScram256Auth;
        this.saslScram512Auth = builder.saslScram512Auth;
        this.type = builder.type;
    }

    public final String basicAuth() {
        return this.basicAuth;
    }

    public final String clientCertificateTlsAuth() {
        return this.clientCertificateTlsAuth;
    }

    public final String saslScram256Auth() {
        return this.saslScram256Auth;
    }

    public final String saslScram512Auth() {
        return this.saslScram512Auth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateTlsAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.saslScram256Auth());
        hashCode = 31 * hashCode + Objects.hashCode(this.saslScram512Auth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedKafkaAccessConfigurationCredentials)) {
            return false;
        }
        SelfManagedKafkaAccessConfigurationCredentials other = (SelfManagedKafkaAccessConfigurationCredentials)obj;
        return Objects.equals(this.basicAuth(), other.basicAuth()) && Objects.equals(this.clientCertificateTlsAuth(), other.clientCertificateTlsAuth()) && Objects.equals(this.saslScram256Auth(), other.saslScram256Auth()) && Objects.equals(this.saslScram512Auth(), other.saslScram512Auth());
    }

    public final String toString() {
        return ToString.builder((String)"SelfManagedKafkaAccessConfigurationCredentials").add("BasicAuth", (Object)this.basicAuth()).add("ClientCertificateTlsAuth", (Object)this.clientCertificateTlsAuth()).add("SaslScram256Auth", (Object)this.saslScram256Auth()).add("SaslScram512Auth", (Object)this.saslScram512Auth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BasicAuth": {
                return Optional.ofNullable(clazz.cast(this.basicAuth()));
            }
            case "ClientCertificateTlsAuth": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateTlsAuth()));
            }
            case "SaslScram256Auth": {
                return Optional.ofNullable(clazz.cast(this.saslScram256Auth()));
            }
            case "SaslScram512Auth": {
                return Optional.ofNullable(clazz.cast(this.saslScram512Auth()));
            }
        }
        return Optional.empty();
    }

    public static SelfManagedKafkaAccessConfigurationCredentials fromBasicAuth(String basicAuth) {
        return (SelfManagedKafkaAccessConfigurationCredentials)SelfManagedKafkaAccessConfigurationCredentials.builder().basicAuth(basicAuth).build();
    }

    public static SelfManagedKafkaAccessConfigurationCredentials fromClientCertificateTlsAuth(String clientCertificateTlsAuth) {
        return (SelfManagedKafkaAccessConfigurationCredentials)SelfManagedKafkaAccessConfigurationCredentials.builder().clientCertificateTlsAuth(clientCertificateTlsAuth).build();
    }

    public static SelfManagedKafkaAccessConfigurationCredentials fromSaslScram256Auth(String saslScram256Auth) {
        return (SelfManagedKafkaAccessConfigurationCredentials)SelfManagedKafkaAccessConfigurationCredentials.builder().saslScram256Auth(saslScram256Auth).build();
    }

    public static SelfManagedKafkaAccessConfigurationCredentials fromSaslScram512Auth(String saslScram512Auth) {
        return (SelfManagedKafkaAccessConfigurationCredentials)SelfManagedKafkaAccessConfigurationCredentials.builder().saslScram512Auth(saslScram512Auth).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedKafkaAccessConfigurationCredentials, T> g) {
        return obj -> g.apply((SelfManagedKafkaAccessConfigurationCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BASIC_AUTH,
        CLIENT_CERTIFICATE_TLS_AUTH,
        SASL_SCRAM256_AUTH,
        SASL_SCRAM512_AUTH,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String basicAuth;
        private String clientCertificateTlsAuth;
        private String saslScram256Auth;
        private String saslScram512Auth;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedKafkaAccessConfigurationCredentials model) {
            this.basicAuth(model.basicAuth);
            this.clientCertificateTlsAuth(model.clientCertificateTlsAuth);
            this.saslScram256Auth(model.saslScram256Auth);
            this.saslScram512Auth(model.saslScram512Auth);
        }

        public final String getBasicAuth() {
            return this.basicAuth;
        }

        public final void setBasicAuth(String basicAuth) {
            String oldValue = this.basicAuth;
            this.basicAuth = basicAuth;
            this.handleUnionValueChange(Type.BASIC_AUTH, oldValue, this.basicAuth);
        }

        @Override
        public final Builder basicAuth(String basicAuth) {
            String oldValue = this.basicAuth;
            this.basicAuth = basicAuth;
            this.handleUnionValueChange(Type.BASIC_AUTH, oldValue, this.basicAuth);
            return this;
        }

        public final String getClientCertificateTlsAuth() {
            return this.clientCertificateTlsAuth;
        }

        public final void setClientCertificateTlsAuth(String clientCertificateTlsAuth) {
            String oldValue = this.clientCertificateTlsAuth;
            this.clientCertificateTlsAuth = clientCertificateTlsAuth;
            this.handleUnionValueChange(Type.CLIENT_CERTIFICATE_TLS_AUTH, oldValue, this.clientCertificateTlsAuth);
        }

        @Override
        public final Builder clientCertificateTlsAuth(String clientCertificateTlsAuth) {
            String oldValue = this.clientCertificateTlsAuth;
            this.clientCertificateTlsAuth = clientCertificateTlsAuth;
            this.handleUnionValueChange(Type.CLIENT_CERTIFICATE_TLS_AUTH, oldValue, this.clientCertificateTlsAuth);
            return this;
        }

        public final String getSaslScram256Auth() {
            return this.saslScram256Auth;
        }

        public final void setSaslScram256Auth(String saslScram256Auth) {
            String oldValue = this.saslScram256Auth;
            this.saslScram256Auth = saslScram256Auth;
            this.handleUnionValueChange(Type.SASL_SCRAM256_AUTH, oldValue, this.saslScram256Auth);
        }

        @Override
        public final Builder saslScram256Auth(String saslScram256Auth) {
            String oldValue = this.saslScram256Auth;
            this.saslScram256Auth = saslScram256Auth;
            this.handleUnionValueChange(Type.SASL_SCRAM256_AUTH, oldValue, this.saslScram256Auth);
            return this;
        }

        public final String getSaslScram512Auth() {
            return this.saslScram512Auth;
        }

        public final void setSaslScram512Auth(String saslScram512Auth) {
            String oldValue = this.saslScram512Auth;
            this.saslScram512Auth = saslScram512Auth;
            this.handleUnionValueChange(Type.SASL_SCRAM512_AUTH, oldValue, this.saslScram512Auth);
        }

        @Override
        public final Builder saslScram512Auth(String saslScram512Auth) {
            String oldValue = this.saslScram512Auth;
            this.saslScram512Auth = saslScram512Auth;
            this.handleUnionValueChange(Type.SASL_SCRAM512_AUTH, oldValue, this.saslScram512Auth);
            return this;
        }

        public SelfManagedKafkaAccessConfigurationCredentials build() {
            return new SelfManagedKafkaAccessConfigurationCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfManagedKafkaAccessConfigurationCredentials> {
        public Builder basicAuth(String var1);

        public Builder clientCertificateTlsAuth(String var1);

        public Builder saslScram256Auth(String var1);

        public Builder saslScram512Auth(String var1);
    }
}

