/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.Order;
import software.amazon.awssdk.services.privatenetworks.model.OrderListCopier;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrdersResponse
extends PrivateNetworksResponse
implements ToCopyableBuilder<Builder, ListOrdersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOrdersResponse.getter(ListOrdersResponse::nextToken)).setter(ListOrdersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Order>> ORDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orders").getter(ListOrdersResponse.getter(ListOrdersResponse::orders)).setter(ListOrdersResponse.setter(Builder::orders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Order::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ORDERS_FIELD));
    private final String nextToken;
    private final List<Order> orders;

    private ListOrdersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.orders = builder.orders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOrders() {
        return this.orders != null && !(this.orders instanceof SdkAutoConstructList);
    }

    public final List<Order> orders() {
        return this.orders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrders() ? this.orders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrdersResponse)) {
            return false;
        }
        ListOrdersResponse other = (ListOrdersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOrders() == other.hasOrders() && Objects.equals(this.orders(), other.orders());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrdersResponse").add("NextToken", (Object)this.nextToken()).add("Orders", this.hasOrders() ? this.orders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "orders": {
                return Optional.ofNullable(clazz.cast(this.orders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrdersResponse, T> g) {
        return obj -> g.apply((ListOrdersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Order> orders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrdersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.orders(model.orders);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Order.Builder> getOrders() {
            List<Order.Builder> result = OrderListCopier.copyToBuilder(this.orders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrders(Collection<Order.BuilderImpl> orders) {
            this.orders = OrderListCopier.copyFromBuilder(orders);
        }

        @Override
        public final Builder orders(Collection<Order> orders) {
            this.orders = OrderListCopier.copy(orders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orders(Order ... orders) {
            this.orders(Arrays.asList(orders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orders(Consumer<Order.Builder> ... orders) {
            this.orders(Stream.of(orders).map(c -> (Order)((Order.Builder)Order.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOrdersResponse build() {
            return new ListOrdersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PrivateNetworksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrdersResponse> {
        public Builder nextToken(String var1);

        public Builder orders(Collection<Order> var1);

        public Builder orders(Order ... var1);

        public Builder orders(Consumer<Order.Builder> ... var1);
    }
}

