/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentUpdateType {
    NONE("NONE"),
    CURRENT_VERSION("CURRENT_VERSION"),
    MINOR_VERSION("MINOR_VERSION"),
    MAJOR_VERSION("MAJOR_VERSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentUpdateType> VALUE_MAP;
    private final String value;

    private DeploymentUpdateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentUpdateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentUpdateType> knownValues() {
        EnumSet<DeploymentUpdateType> knownValues = EnumSet.allOf(DeploymentUpdateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentUpdateType.class, DeploymentUpdateType::toString);
    }
}

