/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.DeploymentSummary;
import software.amazon.awssdk.services.proton.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.proton.model.ListDeploymentsResponse;

public class ListDeploymentsIterable
implements SdkIterable<ListDeploymentsResponse> {
    private final ProtonClient client;
    private final ListDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentsIterable(ProtonClient client, ListDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeploymentsResponseFetcher();
    }

    public Iterator<ListDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeploymentSummary> deployments() {
        Function<ListDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deployments() != null) {
                return response.deployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeploymentsResponseFetcher
    implements SyncPageFetcher<ListDeploymentsResponse> {
        private ListDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentsResponse nextPage(ListDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentsIterable.this.client.listDeployments(ListDeploymentsIterable.this.firstRequest);
            }
            return ListDeploymentsIterable.this.client.listDeployments((ListDeploymentsRequest)((Object)ListDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

