/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.OutputFormat;
import software.amazon.awssdk.services.qldb.model.QldbRequest;
import software.amazon.awssdk.services.qldb.model.S3ExportConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportJournalToS3Request
extends QldbRequest
implements ToCopyableBuilder<Builder, ExportJournalToS3Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ExportJournalToS3Request.getter(ExportJournalToS3Request::name)).setter(ExportJournalToS3Request.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InclusiveStartTime").getter(ExportJournalToS3Request.getter(ExportJournalToS3Request::inclusiveStartTime)).setter(ExportJournalToS3Request.setter(Builder::inclusiveStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build()}).build();
    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExclusiveEndTime").getter(ExportJournalToS3Request.getter(ExportJournalToS3Request::exclusiveEndTime)).setter(ExportJournalToS3Request.setter(Builder::exclusiveEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()}).build();
    private static final SdkField<S3ExportConfiguration> S3_EXPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ExportConfiguration").getter(ExportJournalToS3Request.getter(ExportJournalToS3Request::s3ExportConfiguration)).setter(ExportJournalToS3Request.setter(Builder::s3ExportConfiguration)).constructor(S3ExportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ExportJournalToS3Request.getter(ExportJournalToS3Request::roleArn)).setter(ExportJournalToS3Request.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(ExportJournalToS3Request.getter(ExportJournalToS3Request::outputFormatAsString)).setter(ExportJournalToS3Request.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, S3_EXPORT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, OUTPUT_FORMAT_FIELD));
    private final String name;
    private final Instant inclusiveStartTime;
    private final Instant exclusiveEndTime;
    private final S3ExportConfiguration s3ExportConfiguration;
    private final String roleArn;
    private final String outputFormat;

    private ExportJournalToS3Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.s3ExportConfiguration = builder.s3ExportConfiguration;
        this.roleArn = builder.roleArn;
        this.outputFormat = builder.outputFormat;
    }

    public final String name() {
        return this.name;
    }

    public final Instant inclusiveStartTime() {
        return this.inclusiveStartTime;
    }

    public final Instant exclusiveEndTime() {
        return this.exclusiveEndTime;
    }

    public final S3ExportConfiguration s3ExportConfiguration() {
        return this.s3ExportConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJournalToS3Request)) {
            return false;
        }
        ExportJournalToS3Request other = (ExportJournalToS3Request)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.inclusiveStartTime(), other.inclusiveStartTime()) && Objects.equals(this.exclusiveEndTime(), other.exclusiveEndTime()) && Objects.equals(this.s3ExportConfiguration(), other.s3ExportConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportJournalToS3Request").add("Name", (Object)this.name()).add("InclusiveStartTime", (Object)this.inclusiveStartTime()).add("ExclusiveEndTime", (Object)this.exclusiveEndTime()).add("S3ExportConfiguration", (Object)this.s3ExportConfiguration()).add("RoleArn", (Object)this.roleArn()).add("OutputFormat", (Object)this.outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InclusiveStartTime": {
                return Optional.ofNullable(clazz.cast(this.inclusiveStartTime()));
            }
            case "ExclusiveEndTime": {
                return Optional.ofNullable(clazz.cast(this.exclusiveEndTime()));
            }
            case "S3ExportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3ExportConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJournalToS3Request, T> g) {
        return obj -> g.apply((ExportJournalToS3Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbRequest.BuilderImpl
    implements Builder {
        private String name;
        private Instant inclusiveStartTime;
        private Instant exclusiveEndTime;
        private S3ExportConfiguration s3ExportConfiguration;
        private String roleArn;
        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJournalToS3Request model) {
            super(model);
            this.name(model.name);
            this.inclusiveStartTime(model.inclusiveStartTime);
            this.exclusiveEndTime(model.exclusiveEndTime);
            this.s3ExportConfiguration(model.s3ExportConfiguration);
            this.roleArn(model.roleArn);
            this.outputFormat(model.outputFormat);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getInclusiveStartTime() {
            return this.inclusiveStartTime;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final Instant getExclusiveEndTime() {
            return this.exclusiveEndTime;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final S3ExportConfiguration.Builder getS3ExportConfiguration() {
            return this.s3ExportConfiguration != null ? this.s3ExportConfiguration.toBuilder() : null;
        }

        public final void setS3ExportConfiguration(S3ExportConfiguration.BuilderImpl s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration != null ? s3ExportConfiguration.build() : null;
        }

        @Override
        public final Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportJournalToS3Request build() {
            return new ExportJournalToS3Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportJournalToS3Request> {
        public Builder name(String var1);

        public Builder inclusiveStartTime(Instant var1);

        public Builder exclusiveEndTime(Instant var1);

        public Builder s3ExportConfiguration(S3ExportConfiguration var1);

        default public Builder s3ExportConfiguration(Consumer<S3ExportConfiguration.Builder> s3ExportConfiguration) {
            return this.s3ExportConfiguration((S3ExportConfiguration)((S3ExportConfiguration.Builder)S3ExportConfiguration.builder().applyMutation(s3ExportConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

