/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.ContributorDimensionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContributionAnalysisDefault
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContributionAnalysisDefault> {
    private static final SdkField<String> MEASURE_FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureFieldId").getter(ContributionAnalysisDefault.getter(ContributionAnalysisDefault::measureFieldId)).setter(ContributionAnalysisDefault.setter(Builder::measureFieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureFieldId").build()}).build();
    private static final SdkField<List<ColumnIdentifier>> CONTRIBUTOR_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributorDimensions").getter(ContributionAnalysisDefault.getter(ContributionAnalysisDefault::contributorDimensions)).setter(ContributionAnalysisDefault.setter(Builder::contributorDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_FIELD_ID_FIELD, CONTRIBUTOR_DIMENSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String measureFieldId;
    private final List<ColumnIdentifier> contributorDimensions;

    private ContributionAnalysisDefault(BuilderImpl builder) {
        this.measureFieldId = builder.measureFieldId;
        this.contributorDimensions = builder.contributorDimensions;
    }

    public final String measureFieldId() {
        return this.measureFieldId;
    }

    public final boolean hasContributorDimensions() {
        return this.contributorDimensions != null && !(this.contributorDimensions instanceof SdkAutoConstructList);
    }

    public final List<ColumnIdentifier> contributorDimensions() {
        return this.contributorDimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.measureFieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributorDimensions() ? this.contributorDimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributionAnalysisDefault)) {
            return false;
        }
        ContributionAnalysisDefault other = (ContributionAnalysisDefault)obj;
        return Objects.equals(this.measureFieldId(), other.measureFieldId()) && this.hasContributorDimensions() == other.hasContributorDimensions() && Objects.equals(this.contributorDimensions(), other.contributorDimensions());
    }

    public final String toString() {
        return ToString.builder((String)"ContributionAnalysisDefault").add("MeasureFieldId", (Object)this.measureFieldId()).add("ContributorDimensions", this.hasContributorDimensions() ? this.contributorDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeasureFieldId": {
                return Optional.ofNullable(clazz.cast(this.measureFieldId()));
            }
            case "ContributorDimensions": {
                return Optional.ofNullable(clazz.cast(this.contributorDimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContributionAnalysisDefault, T> g) {
        return obj -> g.apply((ContributionAnalysisDefault)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String measureFieldId;
        private List<ColumnIdentifier> contributorDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContributionAnalysisDefault model) {
            this.measureFieldId(model.measureFieldId);
            this.contributorDimensions(model.contributorDimensions);
        }

        public final String getMeasureFieldId() {
            return this.measureFieldId;
        }

        public final void setMeasureFieldId(String measureFieldId) {
            this.measureFieldId = measureFieldId;
        }

        @Override
        public final Builder measureFieldId(String measureFieldId) {
            this.measureFieldId = measureFieldId;
            return this;
        }

        public final List<ColumnIdentifier.Builder> getContributorDimensions() {
            List<ColumnIdentifier.Builder> result = ContributorDimensionListCopier.copyToBuilder(this.contributorDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributorDimensions(Collection<ColumnIdentifier.BuilderImpl> contributorDimensions) {
            this.contributorDimensions = ContributorDimensionListCopier.copyFromBuilder(contributorDimensions);
        }

        @Override
        public final Builder contributorDimensions(Collection<ColumnIdentifier> contributorDimensions) {
            this.contributorDimensions = ContributorDimensionListCopier.copy(contributorDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorDimensions(ColumnIdentifier ... contributorDimensions) {
            this.contributorDimensions(Arrays.asList(contributorDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorDimensions(Consumer<ColumnIdentifier.Builder> ... contributorDimensions) {
            this.contributorDimensions(Stream.of(contributorDimensions).map(c -> (ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContributionAnalysisDefault build() {
            return new ContributionAnalysisDefault(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContributionAnalysisDefault> {
        public Builder measureFieldId(String var1);

        public Builder contributorDimensions(Collection<ColumnIdentifier> var1);

        public Builder contributorDimensions(ColumnIdentifier ... var1);

        public Builder contributorDimensions(Consumer<ColumnIdentifier.Builder> ... var1);
    }
}

