/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DashboardError;
import software.amazon.awssdk.services.quicksight.model.DashboardErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.DashboardPublishOptions;
import software.amazon.awssdk.services.quicksight.model.DashboardVersionDefinition;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDashboardDefinitionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDashboardDefinitionResponse> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::dashboardId)).setter(DescribeDashboardDefinitionResponse.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<List<DashboardError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::errors)).setter(DescribeDashboardDefinitionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::name)).setter(DescribeDashboardDefinitionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatus").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::resourceStatusAsString)).setter(DescribeDashboardDefinitionResponse.setter(Builder::resourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::themeArn)).setter(DescribeDashboardDefinitionResponse.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<DashboardVersionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::definition)).setter(DescribeDashboardDefinitionResponse.setter(Builder::definition)).constructor(DashboardVersionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::status)).setter(DescribeDashboardDefinitionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::requestId)).setter(DescribeDashboardDefinitionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<DashboardPublishOptions> DASHBOARD_PUBLISH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashboardPublishOptions").getter(DescribeDashboardDefinitionResponse.getter(DescribeDashboardDefinitionResponse::dashboardPublishOptions)).setter(DescribeDashboardDefinitionResponse.setter(Builder::dashboardPublishOptions)).constructor(DashboardPublishOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardPublishOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD, ERRORS_FIELD, NAME_FIELD, RESOURCE_STATUS_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, STATUS_FIELD, REQUEST_ID_FIELD, DASHBOARD_PUBLISH_OPTIONS_FIELD));
    private final String dashboardId;
    private final List<DashboardError> errors;
    private final String name;
    private final String resourceStatus;
    private final String themeArn;
    private final DashboardVersionDefinition definition;
    private final Integer status;
    private final String requestId;
    private final DashboardPublishOptions dashboardPublishOptions;

    private DescribeDashboardDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.errors = builder.errors;
        this.name = builder.name;
        this.resourceStatus = builder.resourceStatus;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.dashboardPublishOptions = builder.dashboardPublishOptions;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<DashboardError> errors() {
        return this.errors;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public final String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final DashboardVersionDefinition definition() {
        return this.definition;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final DashboardPublishOptions dashboardPublishOptions() {
        return this.dashboardPublishOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardPublishOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardDefinitionResponse)) {
            return false;
        }
        DescribeDashboardDefinitionResponse other = (DescribeDashboardDefinitionResponse)((Object)obj);
        return Objects.equals(this.dashboardId(), other.dashboardId()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.themeArn(), other.themeArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.dashboardPublishOptions(), other.dashboardPublishOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDashboardDefinitionResponse").add("DashboardId", (Object)this.dashboardId()).add("Errors", this.hasErrors() ? this.errors() : null).add("Name", (Object)this.name()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ThemeArn", (Object)this.themeArn()).add("Definition", (Object)this.definition()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).add("DashboardPublishOptions", (Object)this.dashboardPublishOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "DashboardPublishOptions": {
                return Optional.ofNullable(clazz.cast(this.dashboardPublishOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeDashboardDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String dashboardId;
        private List<DashboardError> errors = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String resourceStatus;
        private String themeArn;
        private DashboardVersionDefinition definition;
        private Integer status;
        private String requestId;
        private DashboardPublishOptions dashboardPublishOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardDefinitionResponse model) {
            super(model);
            this.dashboardId(model.dashboardId);
            this.errors(model.errors);
            this.name(model.name);
            this.resourceStatus(model.resourceStatus);
            this.themeArn(model.themeArn);
            this.definition(model.definition);
            this.status(model.status);
            this.requestId(model.requestId);
            this.dashboardPublishOptions(model.dashboardPublishOptions);
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<DashboardError.Builder> getErrors() {
            List<DashboardError.Builder> result = DashboardErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<DashboardError.BuilderImpl> errors) {
            this.errors = DashboardErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<DashboardError> errors) {
            this.errors = DashboardErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DashboardError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DashboardError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (DashboardError)((DashboardError.Builder)DashboardError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final DashboardVersionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(DashboardVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(DashboardVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final DashboardPublishOptions.Builder getDashboardPublishOptions() {
            return this.dashboardPublishOptions != null ? this.dashboardPublishOptions.toBuilder() : null;
        }

        public final void setDashboardPublishOptions(DashboardPublishOptions.BuilderImpl dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions != null ? dashboardPublishOptions.build() : null;
        }

        @Override
        public final Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        @Override
        public DescribeDashboardDefinitionResponse build() {
            return new DescribeDashboardDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDashboardDefinitionResponse> {
        public Builder dashboardId(String var1);

        public Builder errors(Collection<DashboardError> var1);

        public Builder errors(DashboardError ... var1);

        public Builder errors(Consumer<DashboardError.Builder> ... var1);

        public Builder name(String var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder themeArn(String var1);

        public Builder definition(DashboardVersionDefinition var1);

        default public Builder definition(Consumer<DashboardVersionDefinition.Builder> definition) {
            return this.definition((DashboardVersionDefinition)((DashboardVersionDefinition.Builder)DashboardVersionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder status(Integer var1);

        public Builder requestId(String var1);

        public Builder dashboardPublishOptions(DashboardPublishOptions var1);

        default public Builder dashboardPublishOptions(Consumer<DashboardPublishOptions.Builder> dashboardPublishOptions) {
            return this.dashboardPublishOptions((DashboardPublishOptions)((DashboardPublishOptions.Builder)DashboardPublishOptions.builder().applyMutation(dashboardPublishOptions)).build());
        }
    }
}

