/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataLabelOptions;
import software.amazon.awssdk.services.quicksight.model.GaugeChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.GaugeChartOptions;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GaugeChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GaugeChartConfiguration> {
    private static final SdkField<GaugeChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(GaugeChartConfiguration.getter(GaugeChartConfiguration::fieldWells)).setter(GaugeChartConfiguration.setter(Builder::fieldWells)).constructor(GaugeChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<GaugeChartOptions> GAUGE_CHART_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GaugeChartOptions").getter(GaugeChartConfiguration.getter(GaugeChartConfiguration::gaugeChartOptions)).setter(GaugeChartConfiguration.setter(Builder::gaugeChartOptions)).constructor(GaugeChartOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GaugeChartOptions").build()}).build();
    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLabels").getter(GaugeChartConfiguration.getter(GaugeChartConfiguration::dataLabels)).setter(GaugeChartConfiguration.setter(Builder::dataLabels)).constructor(DataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TooltipOptions").getter(GaugeChartConfiguration.getter(GaugeChartConfiguration::tooltipOptions)).setter(GaugeChartConfiguration.setter(Builder::tooltipOptions)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipOptions").build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(GaugeChartConfiguration.getter(GaugeChartConfiguration::visualPalette)).setter(GaugeChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, GAUGE_CHART_OPTIONS_FIELD, DATA_LABELS_FIELD, TOOLTIP_OPTIONS_FIELD, VISUAL_PALETTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final GaugeChartFieldWells fieldWells;
    private final GaugeChartOptions gaugeChartOptions;
    private final DataLabelOptions dataLabels;
    private final TooltipOptions tooltipOptions;
    private final VisualPalette visualPalette;

    private GaugeChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.gaugeChartOptions = builder.gaugeChartOptions;
        this.dataLabels = builder.dataLabels;
        this.tooltipOptions = builder.tooltipOptions;
        this.visualPalette = builder.visualPalette;
    }

    public final GaugeChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final GaugeChartOptions gaugeChartOptions() {
        return this.gaugeChartOptions;
    }

    public final DataLabelOptions dataLabels() {
        return this.dataLabels;
    }

    public final TooltipOptions tooltipOptions() {
        return this.tooltipOptions;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.gaugeChartOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltipOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartConfiguration)) {
            return false;
        }
        GaugeChartConfiguration other = (GaugeChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.gaugeChartOptions(), other.gaugeChartOptions()) && Objects.equals(this.dataLabels(), other.dataLabels()) && Objects.equals(this.tooltipOptions(), other.tooltipOptions()) && Objects.equals(this.visualPalette(), other.visualPalette());
    }

    public final String toString() {
        return ToString.builder((String)"GaugeChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("GaugeChartOptions", (Object)this.gaugeChartOptions()).add("DataLabels", (Object)this.dataLabels()).add("TooltipOptions", (Object)this.tooltipOptions()).add("VisualPalette", (Object)this.visualPalette()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "GaugeChartOptions": {
                return Optional.ofNullable(clazz.cast(this.gaugeChartOptions()));
            }
            case "DataLabels": {
                return Optional.ofNullable(clazz.cast(this.dataLabels()));
            }
            case "TooltipOptions": {
                return Optional.ofNullable(clazz.cast(this.tooltipOptions()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartConfiguration, T> g) {
        return obj -> g.apply((GaugeChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GaugeChartFieldWells fieldWells;
        private GaugeChartOptions gaugeChartOptions;
        private DataLabelOptions dataLabels;
        private TooltipOptions tooltipOptions;
        private VisualPalette visualPalette;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.gaugeChartOptions(model.gaugeChartOptions);
            this.dataLabels(model.dataLabels);
            this.tooltipOptions(model.tooltipOptions);
            this.visualPalette(model.visualPalette);
        }

        public final GaugeChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(GaugeChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(GaugeChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final GaugeChartOptions.Builder getGaugeChartOptions() {
            return this.gaugeChartOptions != null ? this.gaugeChartOptions.toBuilder() : null;
        }

        public final void setGaugeChartOptions(GaugeChartOptions.BuilderImpl gaugeChartOptions) {
            this.gaugeChartOptions = gaugeChartOptions != null ? gaugeChartOptions.build() : null;
        }

        @Override
        public final Builder gaugeChartOptions(GaugeChartOptions gaugeChartOptions) {
            this.gaugeChartOptions = gaugeChartOptions;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return this.dataLabels != null ? this.dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltipOptions() {
            return this.tooltipOptions != null ? this.tooltipOptions.toBuilder() : null;
        }

        public final void setTooltipOptions(TooltipOptions.BuilderImpl tooltipOptions) {
            this.tooltipOptions = tooltipOptions != null ? tooltipOptions.build() : null;
        }

        @Override
        public final Builder tooltipOptions(TooltipOptions tooltipOptions) {
            this.tooltipOptions = tooltipOptions;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public GaugeChartConfiguration build() {
            return new GaugeChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GaugeChartConfiguration> {
        public Builder fieldWells(GaugeChartFieldWells var1);

        default public Builder fieldWells(Consumer<GaugeChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((GaugeChartFieldWells)((GaugeChartFieldWells.Builder)GaugeChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder gaugeChartOptions(GaugeChartOptions var1);

        default public Builder gaugeChartOptions(Consumer<GaugeChartOptions.Builder> gaugeChartOptions) {
            return this.gaugeChartOptions((GaugeChartOptions)((GaugeChartOptions.Builder)GaugeChartOptions.builder().applyMutation(gaugeChartOptions)).build());
        }

        public Builder dataLabels(DataLabelOptions var1);

        default public Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return this.dataLabels((DataLabelOptions)((DataLabelOptions.Builder)DataLabelOptions.builder().applyMutation(dataLabels)).build());
        }

        public Builder tooltipOptions(TooltipOptions var1);

        default public Builder tooltipOptions(Consumer<TooltipOptions.Builder> tooltipOptions) {
            return this.tooltipOptions((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltipOptions)).build());
        }

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }
    }
}

