/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DimensionField;
import software.amazon.awssdk.services.quicksight.model.DimensionFieldListCopier;
import software.amazon.awssdk.services.quicksight.model.MeasureField;
import software.amazon.awssdk.services.quicksight.model.MeasureFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialMapAggregatedFieldWells
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialMapAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> GEOSPATIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Geospatial").getter(GeospatialMapAggregatedFieldWells.getter(GeospatialMapAggregatedFieldWells::geospatial)).setter(GeospatialMapAggregatedFieldWells.setter(Builder::geospatial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geospatial").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(GeospatialMapAggregatedFieldWells.getter(GeospatialMapAggregatedFieldWells::values)).setter(GeospatialMapAggregatedFieldWells.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DimensionField>> COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Colors").getter(GeospatialMapAggregatedFieldWells.getter(GeospatialMapAggregatedFieldWells::colors)).setter(GeospatialMapAggregatedFieldWells.setter(Builder::colors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOSPATIAL_FIELD, VALUES_FIELD, COLORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DimensionField> geospatial;
    private final List<MeasureField> values;
    private final List<DimensionField> colors;

    private GeospatialMapAggregatedFieldWells(BuilderImpl builder) {
        this.geospatial = builder.geospatial;
        this.values = builder.values;
        this.colors = builder.colors;
    }

    public final boolean hasGeospatial() {
        return this.geospatial != null && !(this.geospatial instanceof SdkAutoConstructList);
    }

    public final List<DimensionField> geospatial() {
        return this.geospatial;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<MeasureField> values() {
        return this.values;
    }

    public final boolean hasColors() {
        return this.colors != null && !(this.colors instanceof SdkAutoConstructList);
    }

    public final List<DimensionField> colors() {
        return this.colors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeospatial() ? this.geospatial() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColors() ? this.colors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapAggregatedFieldWells)) {
            return false;
        }
        GeospatialMapAggregatedFieldWells other = (GeospatialMapAggregatedFieldWells)obj;
        return this.hasGeospatial() == other.hasGeospatial() && Objects.equals(this.geospatial(), other.geospatial()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasColors() == other.hasColors() && Objects.equals(this.colors(), other.colors());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialMapAggregatedFieldWells").add("Geospatial", this.hasGeospatial() ? this.geospatial() : null).add("Values", this.hasValues() ? this.values() : null).add("Colors", this.hasColors() ? this.colors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Geospatial": {
                return Optional.ofNullable(clazz.cast(this.geospatial()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Colors": {
                return Optional.ofNullable(clazz.cast(this.colors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapAggregatedFieldWells, T> g) {
        return obj -> g.apply((GeospatialMapAggregatedFieldWells)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DimensionField> geospatial = DefaultSdkAutoConstructList.getInstance();
        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();
        private List<DimensionField> colors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapAggregatedFieldWells model) {
            this.geospatial(model.geospatial);
            this.values(model.values);
            this.colors(model.colors);
        }

        public final List<DimensionField.Builder> getGeospatial() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.geospatial);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeospatial(Collection<DimensionField.BuilderImpl> geospatial) {
            this.geospatial = DimensionFieldListCopier.copyFromBuilder(geospatial);
        }

        @Override
        public final Builder geospatial(Collection<DimensionField> geospatial) {
            this.geospatial = DimensionFieldListCopier.copy(geospatial);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geospatial(DimensionField ... geospatial) {
            this.geospatial(Arrays.asList(geospatial));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geospatial(Consumer<DimensionField.Builder> ... geospatial) {
            this.geospatial(Stream.of(geospatial).map(c -> (DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = MeasureFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = MeasureFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getColors() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<DimensionField.BuilderImpl> colors) {
            this.colors = DimensionFieldListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<DimensionField> colors) {
            this.colors = DimensionFieldListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(DimensionField ... colors) {
            this.colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<DimensionField.Builder> ... colors) {
            this.colors(Stream.of(colors).map(c -> (DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GeospatialMapAggregatedFieldWells build() {
            return new GeospatialMapAggregatedFieldWells(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialMapAggregatedFieldWells> {
        public Builder geospatial(Collection<DimensionField> var1);

        public Builder geospatial(DimensionField ... var1);

        public Builder geospatial(Consumer<DimensionField.Builder> ... var1);

        public Builder values(Collection<MeasureField> var1);

        public Builder values(MeasureField ... var1);

        public Builder values(Consumer<MeasureField.Builder> ... var1);

        public Builder colors(Collection<DimensionField> var1);

        public Builder colors(DimensionField ... var1);

        public Builder colors(Consumer<DimensionField.Builder> ... var1);
    }
}

