/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputColumnDataType {
    STRING("STRING"),
    INTEGER("INTEGER"),
    DECIMAL("DECIMAL"),
    DATETIME("DATETIME"),
    BIT("BIT"),
    BOOLEAN("BOOLEAN"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputColumnDataType> VALUE_MAP;
    private final String value;

    private InputColumnDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputColumnDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputColumnDataType> knownValues() {
        EnumSet<InputColumnDataType> knownValues = EnumSet.allOf(InputColumnDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputColumnDataType.class, InputColumnDataType::toString);
    }
}

