/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableFromClusterSnapshotRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, RestoreTableFromClusterSnapshotRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::clusterIdentifier)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotIdentifier").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::snapshotIdentifier)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDatabaseName").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::sourceDatabaseName)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::sourceDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDatabaseName").build()}).build();
    private static final SdkField<String> SOURCE_SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceSchemaName").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::sourceSchemaName)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::sourceSchemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSchemaName").build()}).build();
    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceTableName").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::sourceTableName)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::sourceTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableName").build()}).build();
    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDatabaseName").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::targetDatabaseName)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::targetDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build()}).build();
    private static final SdkField<String> TARGET_SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetSchemaName").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::targetSchemaName)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::targetSchemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSchemaName").build()}).build();
    private static final SdkField<String> NEW_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewTableName").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::newTableName)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::newTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewTableName").build()}).build();
    private static final SdkField<Boolean> ENABLE_CASE_SENSITIVE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCaseSensitiveIdentifier").getter(RestoreTableFromClusterSnapshotRequest.getter(RestoreTableFromClusterSnapshotRequest::enableCaseSensitiveIdentifier)).setter(RestoreTableFromClusterSnapshotRequest.setter(Builder::enableCaseSensitiveIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCaseSensitiveIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, SOURCE_DATABASE_NAME_FIELD, SOURCE_SCHEMA_NAME_FIELD, SOURCE_TABLE_NAME_FIELD, TARGET_DATABASE_NAME_FIELD, TARGET_SCHEMA_NAME_FIELD, NEW_TABLE_NAME_FIELD, ENABLE_CASE_SENSITIVE_IDENTIFIER_FIELD));
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String sourceDatabaseName;
    private final String sourceSchemaName;
    private final String sourceTableName;
    private final String targetDatabaseName;
    private final String targetSchemaName;
    private final String newTableName;
    private final Boolean enableCaseSensitiveIdentifier;

    private RestoreTableFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.newTableName = builder.newTableName;
        this.enableCaseSensitiveIdentifier = builder.enableCaseSensitiveIdentifier;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public final String sourceSchemaName() {
        return this.sourceSchemaName;
    }

    public final String sourceTableName() {
        return this.sourceTableName;
    }

    public final String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public final String targetSchemaName() {
        return this.targetSchemaName;
    }

    public final String newTableName() {
        return this.newTableName;
    }

    public final Boolean enableCaseSensitiveIdentifier() {
        return this.enableCaseSensitiveIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCaseSensitiveIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreTableFromClusterSnapshotRequest other = (RestoreTableFromClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.sourceDatabaseName(), other.sourceDatabaseName()) && Objects.equals(this.sourceSchemaName(), other.sourceSchemaName()) && Objects.equals(this.sourceTableName(), other.sourceTableName()) && Objects.equals(this.targetDatabaseName(), other.targetDatabaseName()) && Objects.equals(this.targetSchemaName(), other.targetSchemaName()) && Objects.equals(this.newTableName(), other.newTableName()) && Objects.equals(this.enableCaseSensitiveIdentifier(), other.enableCaseSensitiveIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTableFromClusterSnapshotRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SourceDatabaseName", (Object)this.sourceDatabaseName()).add("SourceSchemaName", (Object)this.sourceSchemaName()).add("SourceTableName", (Object)this.sourceTableName()).add("TargetDatabaseName", (Object)this.targetDatabaseName()).add("TargetSchemaName", (Object)this.targetSchemaName()).add("NewTableName", (Object)this.newTableName()).add("EnableCaseSensitiveIdentifier", (Object)this.enableCaseSensitiveIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "SourceDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.sourceDatabaseName()));
            }
            case "SourceSchemaName": {
                return Optional.ofNullable(clazz.cast(this.sourceSchemaName()));
            }
            case "SourceTableName": {
                return Optional.ofNullable(clazz.cast(this.sourceTableName()));
            }
            case "TargetDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.targetDatabaseName()));
            }
            case "TargetSchemaName": {
                return Optional.ofNullable(clazz.cast(this.targetSchemaName()));
            }
            case "NewTableName": {
                return Optional.ofNullable(clazz.cast(this.newTableName()));
            }
            case "EnableCaseSensitiveIdentifier": {
                return Optional.ofNullable(clazz.cast(this.enableCaseSensitiveIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromClusterSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreTableFromClusterSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String sourceDatabaseName;
        private String sourceSchemaName;
        private String sourceTableName;
        private String targetDatabaseName;
        private String targetSchemaName;
        private String newTableName;
        private Boolean enableCaseSensitiveIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromClusterSnapshotRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.sourceDatabaseName(model.sourceDatabaseName);
            this.sourceSchemaName(model.sourceSchemaName);
            this.sourceTableName(model.sourceTableName);
            this.targetDatabaseName(model.targetDatabaseName);
            this.targetSchemaName(model.targetSchemaName);
            this.newTableName(model.newTableName);
            this.enableCaseSensitiveIdentifier(model.enableCaseSensitiveIdentifier);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSourceDatabaseName() {
            return this.sourceDatabaseName;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final String getSourceSchemaName() {
            return this.sourceSchemaName;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetSchemaName() {
            return this.targetSchemaName;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final String getNewTableName() {
            return this.newTableName;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final Boolean getEnableCaseSensitiveIdentifier() {
            return this.enableCaseSensitiveIdentifier;
        }

        public final void setEnableCaseSensitiveIdentifier(Boolean enableCaseSensitiveIdentifier) {
            this.enableCaseSensitiveIdentifier = enableCaseSensitiveIdentifier;
        }

        @Override
        public final Builder enableCaseSensitiveIdentifier(Boolean enableCaseSensitiveIdentifier) {
            this.enableCaseSensitiveIdentifier = enableCaseSensitiveIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromClusterSnapshotRequest build() {
            return new RestoreTableFromClusterSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreTableFromClusterSnapshotRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder sourceDatabaseName(String var1);

        public Builder sourceSchemaName(String var1);

        public Builder sourceTableName(String var1);

        public Builder targetDatabaseName(String var1);

        public Builder targetSchemaName(String var1);

        public Builder newTableName(String var1);

        public Builder enableCaseSensitiveIdentifier(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

