/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.Namespace;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreFromSnapshotResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, RestoreFromSnapshotResponse> {
    private static final SdkField<Namespace> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("namespace").getter(RestoreFromSnapshotResponse.getter(RestoreFromSnapshotResponse::namespace)).setter(RestoreFromSnapshotResponse.setter(Builder::namespace)).constructor(Namespace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(RestoreFromSnapshotResponse.getter(RestoreFromSnapshotResponse::ownerAccount)).setter(RestoreFromSnapshotResponse.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(RestoreFromSnapshotResponse.getter(RestoreFromSnapshotResponse::snapshotName)).setter(RestoreFromSnapshotResponse.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, OWNER_ACCOUNT_FIELD, SNAPSHOT_NAME_FIELD));
    private final Namespace namespace;
    private final String ownerAccount;
    private final String snapshotName;

    private RestoreFromSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.ownerAccount = builder.ownerAccount;
        this.snapshotName = builder.snapshotName;
    }

    public final Namespace namespace() {
        return this.namespace;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromSnapshotResponse)) {
            return false;
        }
        RestoreFromSnapshotResponse other = (RestoreFromSnapshotResponse)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.snapshotName(), other.snapshotName());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreFromSnapshotResponse").add("Namespace", (Object)this.namespace()).add("OwnerAccount", (Object)this.ownerAccount()).add("SnapshotName", (Object)this.snapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromSnapshotResponse, T> g) {
        return obj -> g.apply((RestoreFromSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private Namespace namespace;
        private String ownerAccount;
        private String snapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromSnapshotResponse model) {
            super(model);
            this.namespace(model.namespace);
            this.ownerAccount(model.ownerAccount);
            this.snapshotName(model.snapshotName);
        }

        public final Namespace.Builder getNamespace() {
            return this.namespace != null ? this.namespace.toBuilder() : null;
        }

        public final void setNamespace(Namespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public final Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        @Override
        public RestoreFromSnapshotResponse build() {
            return new RestoreFromSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreFromSnapshotResponse> {
        public Builder namespace(Namespace var1);

        default public Builder namespace(Consumer<Namespace.Builder> namespace) {
            return this.namespace((Namespace)((Namespace.Builder)Namespace.builder().applyMutation(namespace)).build());
        }

        public Builder ownerAccount(String var1);

        public Builder snapshotName(String var1);
    }
}

