/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisruptionCompliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DisruptionCompliance> {
    private static final SdkField<Integer> ACHIEVABLE_RPO_IN_SECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("achievableRpoInSecs").getter(DisruptionCompliance.getter(DisruptionCompliance::achievableRpoInSecs)).setter(DisruptionCompliance.setter(Builder::achievableRpoInSecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("achievableRpoInSecs").build()}).build();
    private static final SdkField<Integer> ACHIEVABLE_RTO_IN_SECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("achievableRtoInSecs").getter(DisruptionCompliance.getter(DisruptionCompliance::achievableRtoInSecs)).setter(DisruptionCompliance.setter(Builder::achievableRtoInSecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("achievableRtoInSecs").build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(DisruptionCompliance.getter(DisruptionCompliance::complianceStatusAsString)).setter(DisruptionCompliance.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()}).build();
    private static final SdkField<Integer> CURRENT_RPO_IN_SECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("currentRpoInSecs").getter(DisruptionCompliance.getter(DisruptionCompliance::currentRpoInSecs)).setter(DisruptionCompliance.setter(Builder::currentRpoInSecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRpoInSecs").build()}).build();
    private static final SdkField<Integer> CURRENT_RTO_IN_SECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("currentRtoInSecs").getter(DisruptionCompliance.getter(DisruptionCompliance::currentRtoInSecs)).setter(DisruptionCompliance.setter(Builder::currentRtoInSecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRtoInSecs").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(DisruptionCompliance.getter(DisruptionCompliance::message)).setter(DisruptionCompliance.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> RPO_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rpoDescription").getter(DisruptionCompliance.getter(DisruptionCompliance::rpoDescription)).setter(DisruptionCompliance.setter(Builder::rpoDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoDescription").build()}).build();
    private static final SdkField<String> RPO_REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rpoReferenceId").getter(DisruptionCompliance.getter(DisruptionCompliance::rpoReferenceId)).setter(DisruptionCompliance.setter(Builder::rpoReferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoReferenceId").build()}).build();
    private static final SdkField<String> RTO_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rtoDescription").getter(DisruptionCompliance.getter(DisruptionCompliance::rtoDescription)).setter(DisruptionCompliance.setter(Builder::rtoDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoDescription").build()}).build();
    private static final SdkField<String> RTO_REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rtoReferenceId").getter(DisruptionCompliance.getter(DisruptionCompliance::rtoReferenceId)).setter(DisruptionCompliance.setter(Builder::rtoReferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoReferenceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACHIEVABLE_RPO_IN_SECS_FIELD, ACHIEVABLE_RTO_IN_SECS_FIELD, COMPLIANCE_STATUS_FIELD, CURRENT_RPO_IN_SECS_FIELD, CURRENT_RTO_IN_SECS_FIELD, MESSAGE_FIELD, RPO_DESCRIPTION_FIELD, RPO_REFERENCE_ID_FIELD, RTO_DESCRIPTION_FIELD, RTO_REFERENCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer achievableRpoInSecs;
    private final Integer achievableRtoInSecs;
    private final String complianceStatus;
    private final Integer currentRpoInSecs;
    private final Integer currentRtoInSecs;
    private final String message;
    private final String rpoDescription;
    private final String rpoReferenceId;
    private final String rtoDescription;
    private final String rtoReferenceId;

    private DisruptionCompliance(BuilderImpl builder) {
        this.achievableRpoInSecs = builder.achievableRpoInSecs;
        this.achievableRtoInSecs = builder.achievableRtoInSecs;
        this.complianceStatus = builder.complianceStatus;
        this.currentRpoInSecs = builder.currentRpoInSecs;
        this.currentRtoInSecs = builder.currentRtoInSecs;
        this.message = builder.message;
        this.rpoDescription = builder.rpoDescription;
        this.rpoReferenceId = builder.rpoReferenceId;
        this.rtoDescription = builder.rtoDescription;
        this.rtoReferenceId = builder.rtoReferenceId;
    }

    public final Integer achievableRpoInSecs() {
        return this.achievableRpoInSecs;
    }

    public final Integer achievableRtoInSecs() {
        return this.achievableRtoInSecs;
    }

    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final Integer currentRpoInSecs() {
        return this.currentRpoInSecs;
    }

    public final Integer currentRtoInSecs() {
        return this.currentRtoInSecs;
    }

    public final String message() {
        return this.message;
    }

    public final String rpoDescription() {
        return this.rpoDescription;
    }

    public final String rpoReferenceId() {
        return this.rpoReferenceId;
    }

    public final String rtoDescription() {
        return this.rtoDescription;
    }

    public final String rtoReferenceId() {
        return this.rtoReferenceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.achievableRpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(this.achievableRtoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRtoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.rpoDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.rpoReferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rtoDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.rtoReferenceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisruptionCompliance)) {
            return false;
        }
        DisruptionCompliance other = (DisruptionCompliance)obj;
        return Objects.equals(this.achievableRpoInSecs(), other.achievableRpoInSecs()) && Objects.equals(this.achievableRtoInSecs(), other.achievableRtoInSecs()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.currentRpoInSecs(), other.currentRpoInSecs()) && Objects.equals(this.currentRtoInSecs(), other.currentRtoInSecs()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.rpoDescription(), other.rpoDescription()) && Objects.equals(this.rpoReferenceId(), other.rpoReferenceId()) && Objects.equals(this.rtoDescription(), other.rtoDescription()) && Objects.equals(this.rtoReferenceId(), other.rtoReferenceId());
    }

    public final String toString() {
        return ToString.builder((String)"DisruptionCompliance").add("AchievableRpoInSecs", (Object)this.achievableRpoInSecs()).add("AchievableRtoInSecs", (Object)this.achievableRtoInSecs()).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("CurrentRpoInSecs", (Object)this.currentRpoInSecs()).add("CurrentRtoInSecs", (Object)this.currentRtoInSecs()).add("Message", (Object)this.message()).add("RpoDescription", (Object)this.rpoDescription()).add("RpoReferenceId", (Object)this.rpoReferenceId()).add("RtoDescription", (Object)this.rtoDescription()).add("RtoReferenceId", (Object)this.rtoReferenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "achievableRpoInSecs": {
                return Optional.ofNullable(clazz.cast(this.achievableRpoInSecs()));
            }
            case "achievableRtoInSecs": {
                return Optional.ofNullable(clazz.cast(this.achievableRtoInSecs()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "currentRpoInSecs": {
                return Optional.ofNullable(clazz.cast(this.currentRpoInSecs()));
            }
            case "currentRtoInSecs": {
                return Optional.ofNullable(clazz.cast(this.currentRtoInSecs()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "rpoDescription": {
                return Optional.ofNullable(clazz.cast(this.rpoDescription()));
            }
            case "rpoReferenceId": {
                return Optional.ofNullable(clazz.cast(this.rpoReferenceId()));
            }
            case "rtoDescription": {
                return Optional.ofNullable(clazz.cast(this.rtoDescription()));
            }
            case "rtoReferenceId": {
                return Optional.ofNullable(clazz.cast(this.rtoReferenceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisruptionCompliance, T> g) {
        return obj -> g.apply((DisruptionCompliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer achievableRpoInSecs;
        private Integer achievableRtoInSecs;
        private String complianceStatus;
        private Integer currentRpoInSecs;
        private Integer currentRtoInSecs;
        private String message;
        private String rpoDescription;
        private String rpoReferenceId;
        private String rtoDescription;
        private String rtoReferenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisruptionCompliance model) {
            this.achievableRpoInSecs(model.achievableRpoInSecs);
            this.achievableRtoInSecs(model.achievableRtoInSecs);
            this.complianceStatus(model.complianceStatus);
            this.currentRpoInSecs(model.currentRpoInSecs);
            this.currentRtoInSecs(model.currentRtoInSecs);
            this.message(model.message);
            this.rpoDescription(model.rpoDescription);
            this.rpoReferenceId(model.rpoReferenceId);
            this.rtoDescription(model.rtoDescription);
            this.rtoReferenceId(model.rtoReferenceId);
        }

        public final Integer getAchievableRpoInSecs() {
            return this.achievableRpoInSecs;
        }

        public final void setAchievableRpoInSecs(Integer achievableRpoInSecs) {
            this.achievableRpoInSecs = achievableRpoInSecs;
        }

        @Override
        public final Builder achievableRpoInSecs(Integer achievableRpoInSecs) {
            this.achievableRpoInSecs = achievableRpoInSecs;
            return this;
        }

        public final Integer getAchievableRtoInSecs() {
            return this.achievableRtoInSecs;
        }

        public final void setAchievableRtoInSecs(Integer achievableRtoInSecs) {
            this.achievableRtoInSecs = achievableRtoInSecs;
        }

        @Override
        public final Builder achievableRtoInSecs(Integer achievableRtoInSecs) {
            this.achievableRtoInSecs = achievableRtoInSecs;
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Integer getCurrentRpoInSecs() {
            return this.currentRpoInSecs;
        }

        public final void setCurrentRpoInSecs(Integer currentRpoInSecs) {
            this.currentRpoInSecs = currentRpoInSecs;
        }

        @Override
        public final Builder currentRpoInSecs(Integer currentRpoInSecs) {
            this.currentRpoInSecs = currentRpoInSecs;
            return this;
        }

        public final Integer getCurrentRtoInSecs() {
            return this.currentRtoInSecs;
        }

        public final void setCurrentRtoInSecs(Integer currentRtoInSecs) {
            this.currentRtoInSecs = currentRtoInSecs;
        }

        @Override
        public final Builder currentRtoInSecs(Integer currentRtoInSecs) {
            this.currentRtoInSecs = currentRtoInSecs;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getRpoDescription() {
            return this.rpoDescription;
        }

        public final void setRpoDescription(String rpoDescription) {
            this.rpoDescription = rpoDescription;
        }

        @Override
        public final Builder rpoDescription(String rpoDescription) {
            this.rpoDescription = rpoDescription;
            return this;
        }

        public final String getRpoReferenceId() {
            return this.rpoReferenceId;
        }

        public final void setRpoReferenceId(String rpoReferenceId) {
            this.rpoReferenceId = rpoReferenceId;
        }

        @Override
        public final Builder rpoReferenceId(String rpoReferenceId) {
            this.rpoReferenceId = rpoReferenceId;
            return this;
        }

        public final String getRtoDescription() {
            return this.rtoDescription;
        }

        public final void setRtoDescription(String rtoDescription) {
            this.rtoDescription = rtoDescription;
        }

        @Override
        public final Builder rtoDescription(String rtoDescription) {
            this.rtoDescription = rtoDescription;
            return this;
        }

        public final String getRtoReferenceId() {
            return this.rtoReferenceId;
        }

        public final void setRtoReferenceId(String rtoReferenceId) {
            this.rtoReferenceId = rtoReferenceId;
        }

        @Override
        public final Builder rtoReferenceId(String rtoReferenceId) {
            this.rtoReferenceId = rtoReferenceId;
            return this;
        }

        public DisruptionCompliance build() {
            return new DisruptionCompliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DisruptionCompliance> {
        public Builder achievableRpoInSecs(Integer var1);

        public Builder achievableRtoInSecs(Integer var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(ComplianceStatus var1);

        public Builder currentRpoInSecs(Integer var1);

        public Builder currentRtoInSecs(Integer var1);

        public Builder message(String var1);

        public Builder rpoDescription(String var1);

        public Builder rpoReferenceId(String var1);

        public Builder rtoDescription(String var1);

        public Builder rtoReferenceId(String var1);
    }
}

