/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceDrift;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceDriftListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppAssessmentComplianceDriftsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppAssessmentComplianceDriftsResponse> {
    private static final SdkField<List<ComplianceDrift>> COMPLIANCE_DRIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("complianceDrifts").getter(ListAppAssessmentComplianceDriftsResponse.getter(ListAppAssessmentComplianceDriftsResponse::complianceDrifts)).setter(ListAppAssessmentComplianceDriftsResponse.setter(Builder::complianceDrifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceDrifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComplianceDrift::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppAssessmentComplianceDriftsResponse.getter(ListAppAssessmentComplianceDriftsResponse::nextToken)).setter(ListAppAssessmentComplianceDriftsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_DRIFTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ComplianceDrift> complianceDrifts;
    private final String nextToken;

    private ListAppAssessmentComplianceDriftsResponse(BuilderImpl builder) {
        super(builder);
        this.complianceDrifts = builder.complianceDrifts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComplianceDrifts() {
        return this.complianceDrifts != null && !(this.complianceDrifts instanceof SdkAutoConstructList);
    }

    public final List<ComplianceDrift> complianceDrifts() {
        return this.complianceDrifts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceDrifts() ? this.complianceDrifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAssessmentComplianceDriftsResponse)) {
            return false;
        }
        ListAppAssessmentComplianceDriftsResponse other = (ListAppAssessmentComplianceDriftsResponse)((Object)obj);
        return this.hasComplianceDrifts() == other.hasComplianceDrifts() && Objects.equals(this.complianceDrifts(), other.complianceDrifts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppAssessmentComplianceDriftsResponse").add("ComplianceDrifts", this.hasComplianceDrifts() ? this.complianceDrifts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "complianceDrifts": {
                return Optional.ofNullable(clazz.cast(this.complianceDrifts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppAssessmentComplianceDriftsResponse, T> g) {
        return obj -> g.apply((ListAppAssessmentComplianceDriftsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<ComplianceDrift> complianceDrifts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAssessmentComplianceDriftsResponse model) {
            super(model);
            this.complianceDrifts(model.complianceDrifts);
            this.nextToken(model.nextToken);
        }

        public final List<ComplianceDrift.Builder> getComplianceDrifts() {
            List<ComplianceDrift.Builder> result = ComplianceDriftListCopier.copyToBuilder(this.complianceDrifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceDrifts(Collection<ComplianceDrift.BuilderImpl> complianceDrifts) {
            this.complianceDrifts = ComplianceDriftListCopier.copyFromBuilder(complianceDrifts);
        }

        @Override
        public final Builder complianceDrifts(Collection<ComplianceDrift> complianceDrifts) {
            this.complianceDrifts = ComplianceDriftListCopier.copy(complianceDrifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceDrifts(ComplianceDrift ... complianceDrifts) {
            this.complianceDrifts(Arrays.asList(complianceDrifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceDrifts(Consumer<ComplianceDrift.Builder> ... complianceDrifts) {
            this.complianceDrifts(Stream.of(complianceDrifts).map(c -> (ComplianceDrift)((ComplianceDrift.Builder)ComplianceDrift.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppAssessmentComplianceDriftsResponse build() {
            return new ListAppAssessmentComplianceDriftsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppAssessmentComplianceDriftsResponse> {
        public Builder complianceDrifts(Collection<ComplianceDrift> var1);

        public Builder complianceDrifts(ComplianceDrift ... var1);

        public Builder complianceDrifts(Consumer<ComplianceDrift.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

