/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResiliencyPolicyTier {
    MISSION_CRITICAL("MissionCritical"),
    CRITICAL("Critical"),
    IMPORTANT("Important"),
    CORE_SERVICES("CoreServices"),
    NON_CRITICAL("NonCritical"),
    NOT_APPLICABLE("NotApplicable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResiliencyPolicyTier> VALUE_MAP;
    private final String value;

    private ResiliencyPolicyTier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResiliencyPolicyTier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResiliencyPolicyTier> knownValues() {
        EnumSet<ResiliencyPolicyTier> knownValues = EnumSet.allOf(ResiliencyPolicyTier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResiliencyPolicyTier.class, ResiliencyPolicyTier::toString);
    }
}

