/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceImportStatusType {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    SUCCESS("Success"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceImportStatusType> VALUE_MAP;
    private final String value;

    private ResourceImportStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceImportStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceImportStatusType> knownValues() {
        EnumSet<ResourceImportStatusType> knownValues = EnumSet.allOf(ResourceImportStatusType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceImportStatusType.class, ResourceImportStatusType::toString);
    }
}

