/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse;

public class ListRecommendationTemplatesPublisher
implements SdkPublisher<ListRecommendationTemplatesResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListRecommendationTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendationTemplatesPublisher(ResiliencehubAsyncClient client, ListRecommendationTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendationTemplatesPublisher(ResiliencehubAsyncClient client, ListRecommendationTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendationTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendationTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRecommendationTemplatesResponseFetcher
    implements AsyncPageFetcher<ListRecommendationTemplatesResponse> {
        private ListRecommendationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendationTemplatesResponse> nextPage(ListRecommendationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationTemplatesPublisher.this.client.listRecommendationTemplates(ListRecommendationTemplatesPublisher.this.firstRequest);
            }
            return ListRecommendationTemplatesPublisher.this.client.listRecommendationTemplates((ListRecommendationTemplatesRequest)((Object)ListRecommendationTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

