/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.services.resourceexplorer2.model.ViewArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListViewsResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, ListViewsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListViewsResponse.getter(ListViewsResponse::nextToken)).setter(ListViewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Views").getter(ListViewsResponse.getter(ListViewsResponse::views)).setter(ListViewsResponse.setter(Builder::views)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Views").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VIEWS_FIELD));
    private final String nextToken;
    private final List<String> views;

    private ListViewsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.views = builder.views;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasViews() {
        return this.views != null && !(this.views instanceof SdkAutoConstructList);
    }

    public final List<String> views() {
        return this.views;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViews() ? this.views() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViewsResponse)) {
            return false;
        }
        ListViewsResponse other = (ListViewsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasViews() == other.hasViews() && Objects.equals(this.views(), other.views());
    }

    public final String toString() {
        return ToString.builder((String)"ListViewsResponse").add("NextToken", (Object)this.nextToken()).add("Views", this.hasViews() ? this.views() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Views": {
                return Optional.ofNullable(clazz.cast(this.views()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListViewsResponse, T> g) {
        return obj -> g.apply((ListViewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> views = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListViewsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.views(model.views);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getViews() {
            if (this.views instanceof SdkAutoConstructList) {
                return null;
            }
            return this.views;
        }

        public final void setViews(Collection<String> views) {
            this.views = ViewArnListCopier.copy(views);
        }

        @Override
        public final Builder views(Collection<String> views) {
            this.views = ViewArnListCopier.copy(views);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder views(String ... views) {
            this.views(Arrays.asList(views));
            return this;
        }

        @Override
        public ListViewsResponse build() {
            return new ListViewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListViewsResponse> {
        public Builder nextToken(String var1);

        public Builder views(Collection<String> var1);

        public Builder views(String ... var1);
    }
}

