/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.robomaker.DefaultRoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.DefaultRoboMakerBaseClientBuilder;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClientBuilder;
import software.amazon.awssdk.services.robomaker.RoboMakerServiceClientConfiguration;
import software.amazon.awssdk.services.robomaker.endpoints.RoboMakerEndpointProvider;

@SdkInternalApi
final class DefaultRoboMakerAsyncClientBuilder
extends DefaultRoboMakerBaseClientBuilder<RoboMakerAsyncClientBuilder, RoboMakerAsyncClient>
implements RoboMakerAsyncClientBuilder {
    DefaultRoboMakerAsyncClientBuilder() {
    }

    @Override
    public DefaultRoboMakerAsyncClientBuilder endpointProvider(RoboMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RoboMakerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRoboMakerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RoboMakerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRoboMakerAsyncClient client = new DefaultRoboMakerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RoboMakerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RoboMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

