/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExitBehavior {
    FAIL("FAIL"),
    RESTART("RESTART"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExitBehavior> VALUE_MAP;
    private final String value;

    private ExitBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExitBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExitBehavior> knownValues() {
        EnumSet<ExitBehavior> knownValues = EnumSet.allOf(ExitBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExitBehavior.class, ExitBehavior::toString);
    }
}

