/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.SimulationJobBatchStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationJobBatchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationJobBatchSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::arn)).setter(SimulationJobBatchSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::lastUpdatedAt)).setter(SimulationJobBatchSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::createdAt)).setter(SimulationJobBatchSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::statusAsString)).setter(SimulationJobBatchSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> FAILED_REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failedRequestCount").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::failedRequestCount)).setter(SimulationJobBatchSummary.setter(Builder::failedRequestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequestCount").build()}).build();
    private static final SdkField<Integer> PENDING_REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pendingRequestCount").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::pendingRequestCount)).setter(SimulationJobBatchSummary.setter(Builder::pendingRequestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingRequestCount").build()}).build();
    private static final SdkField<Integer> CREATED_REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("createdRequestCount").getter(SimulationJobBatchSummary.getter(SimulationJobBatchSummary::createdRequestCount)).setter(SimulationJobBatchSummary.setter(Builder::createdRequestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdRequestCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, STATUS_FIELD, FAILED_REQUEST_COUNT_FIELD, PENDING_REQUEST_COUNT_FIELD, CREATED_REQUEST_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant lastUpdatedAt;
    private final Instant createdAt;
    private final String status;
    private final Integer failedRequestCount;
    private final Integer pendingRequestCount;
    private final Integer createdRequestCount;

    private SimulationJobBatchSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.failedRequestCount = builder.failedRequestCount;
        this.pendingRequestCount = builder.pendingRequestCount;
        this.createdRequestCount = builder.createdRequestCount;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final SimulationJobBatchStatus status() {
        return SimulationJobBatchStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer failedRequestCount() {
        return this.failedRequestCount;
    }

    public final Integer pendingRequestCount() {
        return this.pendingRequestCount;
    }

    public final Integer createdRequestCount() {
        return this.createdRequestCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdRequestCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobBatchSummary)) {
            return false;
        }
        SimulationJobBatchSummary other = (SimulationJobBatchSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failedRequestCount(), other.failedRequestCount()) && Objects.equals(this.pendingRequestCount(), other.pendingRequestCount()) && Objects.equals(this.createdRequestCount(), other.createdRequestCount());
    }

    public final String toString() {
        return ToString.builder((String)"SimulationJobBatchSummary").add("Arn", (Object)this.arn()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("FailedRequestCount", (Object)this.failedRequestCount()).add("PendingRequestCount", (Object)this.pendingRequestCount()).add("CreatedRequestCount", (Object)this.createdRequestCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failedRequestCount": {
                return Optional.ofNullable(clazz.cast(this.failedRequestCount()));
            }
            case "pendingRequestCount": {
                return Optional.ofNullable(clazz.cast(this.pendingRequestCount()));
            }
            case "createdRequestCount": {
                return Optional.ofNullable(clazz.cast(this.createdRequestCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJobBatchSummary, T> g) {
        return obj -> g.apply((SimulationJobBatchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant lastUpdatedAt;
        private Instant createdAt;
        private String status;
        private Integer failedRequestCount;
        private Integer pendingRequestCount;
        private Integer createdRequestCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJobBatchSummary model) {
            this.arn(model.arn);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.failedRequestCount(model.failedRequestCount);
            this.pendingRequestCount(model.pendingRequestCount);
            this.createdRequestCount(model.createdRequestCount);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobBatchStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getFailedRequestCount() {
            return this.failedRequestCount;
        }

        public final void setFailedRequestCount(Integer failedRequestCount) {
            this.failedRequestCount = failedRequestCount;
        }

        @Override
        public final Builder failedRequestCount(Integer failedRequestCount) {
            this.failedRequestCount = failedRequestCount;
            return this;
        }

        public final Integer getPendingRequestCount() {
            return this.pendingRequestCount;
        }

        public final void setPendingRequestCount(Integer pendingRequestCount) {
            this.pendingRequestCount = pendingRequestCount;
        }

        @Override
        public final Builder pendingRequestCount(Integer pendingRequestCount) {
            this.pendingRequestCount = pendingRequestCount;
            return this;
        }

        public final Integer getCreatedRequestCount() {
            return this.createdRequestCount;
        }

        public final void setCreatedRequestCount(Integer createdRequestCount) {
            this.createdRequestCount = createdRequestCount;
        }

        @Override
        public final Builder createdRequestCount(Integer createdRequestCount) {
            this.createdRequestCount = createdRequestCount;
            return this;
        }

        public SimulationJobBatchSummary build() {
            return new SimulationJobBatchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationJobBatchSummary> {
        public Builder arn(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SimulationJobBatchStatus var1);

        public Builder failedRequestCount(Integer var1);

        public Builder pendingRequestCount(Integer var1);

        public Builder createdRequestCount(Integer var1);
    }
}

