/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorldGenerationJobErrorCode {
    INTERNAL_SERVICE_ERROR("InternalServiceError"),
    LIMIT_EXCEEDED("LimitExceeded"),
    RESOURCE_NOT_FOUND("ResourceNotFound"),
    REQUEST_THROTTLED("RequestThrottled"),
    INVALID_INPUT("InvalidInput"),
    ALL_WORLD_GENERATION_FAILED("AllWorldGenerationFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorldGenerationJobErrorCode> VALUE_MAP;
    private final String value;

    private WorldGenerationJobErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorldGenerationJobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorldGenerationJobErrorCode> knownValues() {
        EnumSet<WorldGenerationJobErrorCode> knownValues = EnumSet.allOf(WorldGenerationJobErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorldGenerationJobErrorCode.class, WorldGenerationJobErrorCode::toString);
    }
}

