/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationJobSummary;

public class ListSimulationJobsIterable
implements SdkIterable<ListSimulationJobsResponse> {
    private final RoboMakerClient client;
    private final ListSimulationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSimulationJobsIterable(RoboMakerClient client, ListSimulationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSimulationJobsResponseFetcher();
    }

    public Iterator<ListSimulationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SimulationJobSummary> simulationJobSummaries() {
        Function<ListSimulationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.simulationJobSummaries() != null) {
                return response.simulationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSimulationJobsResponseFetcher
    implements SyncPageFetcher<ListSimulationJobsResponse> {
        private ListSimulationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSimulationJobsResponse nextPage(ListSimulationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationJobsIterable.this.client.listSimulationJobs(ListSimulationJobsIterable.this.firstRequest);
            }
            return ListSimulationJobsIterable.this.client.listSimulationJobs((ListSimulationJobsRequest)((Object)ListSimulationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

