/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereClient;
import software.amazon.awssdk.services.rolesanywhere.internal.UserAgentUtils;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.SubjectSummary;

public class ListSubjectsIterable
implements SdkIterable<ListSubjectsResponse> {
    private final RolesAnywhereClient client;
    private final ListSubjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubjectsIterable(RolesAnywhereClient client, ListSubjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubjectsResponseFetcher();
    }

    public Iterator<ListSubjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubjectSummary> subjects() {
        Function<ListSubjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subjects() != null) {
                return response.subjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubjectsResponseFetcher
    implements SyncPageFetcher<ListSubjectsResponse> {
        private ListSubjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubjectsResponse nextPage(ListSubjectsResponse previousPage) {
            if (previousPage == null) {
                return ListSubjectsIterable.this.client.listSubjects(ListSubjectsIterable.this.firstRequest);
            }
            return ListSubjectsIterable.this.client.listSubjects((ListSubjectsRequest)((Object)ListSubjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

